/**
 * Description: CmProductStat数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-03-16 下午 17:11:49
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-03-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmProductStatEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICmProductStatDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * CmProductStat数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-03-16
 * @see
 * @since 1.0
 */
@Repository("cmProductStatDao")
public class CmProductStatDaoImpl extends DefaultDaoImpl<CmProductStatEntity> implements ICmProductStatDao<CmProductStatEntity> {

    @Override
    public void initialData() {
        this.getWriteTemplate().insert(getStatement());
    }

    @Override
    public void truncateTable() {
        this.getWriteTemplate().delete(getStatement());
    }

    @Override
    public void saveOrUpdate(CmCreditGoodsEntity goodsEntity) {
        this.getWriteTemplate().insert(getStatement(), goodsEntity);
    }

    @Override
    public List<CmProductStatEntity> statByCity() {
        return this.getReadTemplate().queryForList(getStatement());
    }

    @Override
    public List<CmProductStatEntity> statByDate(String cityName) {
        return this.getReadTemplate().queryForList(getStatement(), cityName);
    }

}
