/**
 * Description: CmHouse数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:14
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.house365.beans.entity.CmHouseEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICmHouseDao;

/**
 * CmHouse数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Repository("cmHouseDao")
public class CmHouseDaoImpl extends DefaultDaoImpl<CmHouseEntity> implements ICmHouseDao<CmHouseEntity> {

    @Override
    public CmHouseEntity getHouseByHouseId(Integer houseId, String city, Integer channel) {
        Map<String, Object> map = new HashMap<>();
        map.put("houseId", houseId);
        map.put("cityKey", city);
        map.put("channel", channel);
        return this.getEntity(getStatement(), map);
    }

    @Override
    public void increaseComment(Integer id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        this.update(getStatement(), map);
    }

}
