/**
 * Description: CmHouseComment数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CmHouseCommentEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICmHouseCommentDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * CmHouseComment数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Repository("cmHouseCommentDao")
public class CmHouseCommentDaoImpl extends DefaultDaoImpl<CmHouseCommentEntity> implements ICmHouseCommentDao<CmHouseCommentEntity> {

    @Override
    public int getDistinctHouseCount(Object params) {
        return uniqueIntResult(getStatement(), params);
    }

    @Override
    public void updateHouseName(Integer houseId, String houseName) {
        Map<String, Object> map = new HashMap<>();
        map.put("houseId", houseId);
        map.put("houseName", houseName);
        this.update(getStatement(), map);
    }


}
