/**
 * Description: CmExchangeCode数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:13
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.house365.beans.entity.CmExchangeCodeEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICmExchangeCodeDao;

/**
 * CmExchangeCode数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Repository("cmExchangeCodeDao")
public class CmExchangeCodeDaoImpl extends DefaultDaoImpl<CmExchangeCodeEntity> implements ICmExchangeCodeDao<CmExchangeCodeEntity> {

    @SuppressWarnings("deprecation")
    @Override
    public Integer deleteByBatchCode(Integer batchId) {
        return this.getReadTemplate().update(getStatement(), batchId);
    }


    @Override
    public CmExchangeCodeEntity getFirstByStatusAndGoodsId(Integer status, Integer goodsId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("EQ_status", status);
        params.put("EQ_goodId", goodsId);
        QueryParams<CmExchangeCodeEntity> qp = new QueryParams<CmExchangeCodeEntity>();
        Page paging = new Page();
        paging.setCurrentPage(1);
        paging.setPageSize(1);
        qp.setPaging(paging);
        qp.setSearchParams(params);
        List<CmExchangeCodeEntity> list = this.queryByPage(qp);
        if (list == null || list.size() < 1) {
            return null;
        }
        return list.get(0);
    }

    @SuppressWarnings({"unchecked", "deprecation"})
    @Override
    public List<CmExchangeCodeEntity> getNotRepeat(Map<String, Object> params) {
        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @SuppressWarnings("deprecation")
    @Override
    public CmExchangeCodeEntity getIsRepeat(Map<String, Object> params) {
        return (CmExchangeCodeEntity) this.getReadTemplate().queryForObject(getStatement(), params);
    }
}
