package com.house365.ws.Timer;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.house365.beans.entity.CmSeckillRemindEntity;
import com.house365.beans.system.QueryParams;
import com.house365.commons.system.SmsUtils;
import com.house365.web.util.MemoryPropertyPlaceholderConfigurer;
import com.house365.ws.dao.interfaces.ICmSeckillRemindDao;

/**
 * 秒杀活动开始提醒
 *
 * @author duhui
 * @version [1.0.0, 2015-2-12]
 */
@Service("smsReminderTimer")
public class SendSmsTimer {
    
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(SendSmsTimer.class);
    
    /**
     * 提醒dao
     */
    @Autowired
    private ICmSeckillRemindDao<CmSeckillRemindEntity> secKillRemindDao;
       
    
    /**
     * 非必传字段，邮编
     */
    private static final String  ZIPCODE= "zipCode";
    
    /**
     * 提醒时间（分钟）
     */
    @Value("#{system.remindTimeBefore}")  
    private Integer REMIND_TIME_BEFORE=0;
    
    /**
     * 开拍提醒短信
     */
    public void sendRemindSms() {
        // 查找大于当前时间一定时间的提醒
        QueryParams<CmSeckillRemindEntity> queryParams = new QueryParams<CmSeckillRemindEntity>();
        Calendar nowCal = Calendar.getInstance();
        nowCal.add(Calendar.MINUTE, REMIND_TIME_BEFORE);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("LT_remindTime", nowCal.getTime());
        queryParams.setSearchParams(map);
        List<CmSeckillRemindEntity> list = secKillRemindDao.queryAll(queryParams);
        // 取得短信接口URL
        String smsUrl = MemoryPropertyPlaceholderConfigurer.getContextProperty("system.default.smsUrl");
        //验证码通道改为通知通道
        smsUrl = smsUrl.replaceAll("69","70");
        for(CmSeckillRemindEntity entity : list){
            try{
                SmsUtils.sendSeckillRemindSms("nj", entity.getUserPhone(),"您关注的积分商城活动就要开始了，赶快去看看吧!",smsUrl);
                //SmsUtils.sendSeckillRemindSms("nj", "13082511415","【淘房拍】银城一方山啊等送发松岛将于2015-03-05 14:10:55开始，请准时参加！","http://mysms.house365.com:81/index.php/Interface/apiSendMobil/jid/69/depart/1/city/");
//                System.out.println("发送了短信:"+entity.getUserPhone()+"");
                //SmsUtils.sendSms(entity.getCity(), entity.getPhone(), entity.getMessage());
                secKillRemindDao.delete(entity.getId());
            }catch(Exception e){
                e.printStackTrace();
                continue;
            }
        }
    }    
}
