package com.house365.ws.Timer;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmSeckillBookedEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.CmConstant;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.interfaces.ICmSeckillBookedDao;
import com.house365.ws.service.interfaces.ICmCreditGoodsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 秒杀活动开始提醒
 *
 * @author duhui
 * @version [1.0.0, 2015-2-12]
 */
@Service("goodsRecycleTimer")
public class GoodsRecycleTimer {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsRecycleTimer.class);

    /**
     * 回收周期（分钟）
     */
    @Value("#{system.recycleTime}")
    private Integer RECYCLE_TIME = 0;

    @Autowired
    RedisUtilsInterface redisUtils;

    @Autowired
    ICmCreditGoodsService<CmCreditGoodsEntity> cmCreditGoodsService;


    /**
     * 秒杀dao
     */
    @Autowired
    private ICmSeckillBookedDao<CmSeckillBookedEntity> secKillBookedDao;

    /**
     * 回收秒杀订单
     */
    public void recycleGoods() {
        //查询数据库中，过期订单
        QueryParams<CmSeckillBookedEntity> queryParams = new QueryParams<CmSeckillBookedEntity>();
        Map<String, Object> map = new HashMap<String, Object>();
        //如果秒杀时间过N分钟后，回收
        Calendar nowCal = Calendar.getInstance();
        nowCal.add(Calendar.MINUTE, -RECYCLE_TIME);
        map.put("LT_createTime", nowCal.getTime());
        queryParams.setSearchParams(map);
        List<CmSeckillBookedEntity> list = secKillBookedDao.queryAll(queryParams);
        if (list != null && !list.isEmpty()) {
            LOGGER.info("run recycleGoods, there are {} booked will be recycle !", list.size());
            for (CmSeckillBookedEntity entity : list) {
                try {
                    LOGGER.info("run recycleGoods, recycle record {} !", entity);
                    secKillBookedDao.delete(entity.getId());
                    redisUtils.pushIntegerIntoRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST + entity.getGoodId(), 1);
                } catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }

    public void soldoutJob() {
        QueryParams<CmCreditGoodsEntity> queryParam = new QueryParams<>();
        Map<String, Object> param = new HashMap<>();
        param.put("EQ_inSoldOutRange", "1");
        //只显示已上架商品
        param.put("EQ_status", 0);
        param.put("EQ_avilableonly", 1);
        param.put("EQ_goodsType", "2");
        queryParam.setPaging(new Page(1));
        queryParam.setSearchParams(param);
        List<CmCreditGoodsEntity> cmList = cmCreditGoodsService.queryByPage(queryParam);
        for (CmCreditGoodsEntity good : cmList) {
            good.setStatus(1);
            cmCreditGoodsService.update(good);
        }

    }
}
