/**
 * Description: CmUserWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.entity.ExportLogEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmUserListRequest;
import com.house365.ws.beans.request.CmUserRequest;
import com.house365.ws.beans.response.CmUserListResponse;
import com.house365.ws.beans.response.CmUserResponse;

import java.util.List;
import java.util.Map;


/**
 * CmUserWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmUser extends IService {

    /**
     * CmUser列表查询
     *
     * @param request CmUser列表查询请求
     * @return CmUser列表查询响应
     */
    CmUserListResponse getCmUserList(CmUserListRequest request);

    /**
     * 保存CmUser
     *
     * @param request CmUser请求
     * @return 保存CmUser响应
     */
    CmUserResponse addCmUser(CmUserRequest request);

    /**
     * 删除CmUser通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmUser响应
     */
    CmUserResponse deleteCmUserById(Integer id);

    /**
     * 修改CmUser
     *
     * @param request 修改CmUser请求
     * @return 修改CmUser响应
     */
    CmUserResponse updateCmUser(CmUserRequest request);

    /**
     * 通过ID获取CmUser
     *
     * @param id 唯一标识
     * @return 通过ID获取CmUser响应
     */
    CmUserResponse getCmUserById(Integer id);


    /**
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllCreditsNotNull();

    /**
     * 查询所有积分余额
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllRemainingCredits();


    void signRemind();

    CmUserResponse getUserByPhone(String phone);

    /**
     * 查询榜单 type 1:团队当季；2:历史团队
     *
     * @param request CmUser列表查询请求
     * @return CmUser列表查询响应
     */
    CmUserListResponse selectRanksByDivision(CmUserListRequest request);

    /**
     * 查询个人榜单 3:个人当季；4:历史个人
     *
     * @param request CmUser列表查询请求
     * @return CmUser列表查询响应
     */
    CmUserListResponse selectRanksByInvite(CmUserListRequest request);

    /**
     * 查询个人推荐信息
     *
     * @param request
     * @return
     */
    CmUserResponse getRankByInvite(CmUserListRequest request);

    CmUserListResponse list(CmUserListRequest request, String startTime, String endTime, String phone);

    CmUserListResponse stepList(CmUserListRequest request, int inviteCode, String startTime, String endTime);

    List<Map<String, Object>> queryList(Map<String, Object> map);

    List<CmUserEntity> exportStepList(Map<String, Object> map);

    void save(ExportLogEntity logEntity);
}
