/**
 * Description: CmReplyPraiseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-11 上午 09:31:52
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmReplyPraiseListRequest;
import com.house365.ws.beans.request.CmReplyPraiseRequest;
import com.house365.ws.beans.response.CmReplyPraiseListResponse;
import com.house365.ws.beans.response.CmReplyPraiseResponse;


/**
 * CmReplyPraiseWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
public interface ICmReplyPraise extends IService{

    /**
     * CmReplyPraise列表查询
     * 
     * @param request
     *            CmReplyPraise列表查询请求
     * @return CmReplyPraise列表查询响应
     */
    CmReplyPraiseListResponse getCmReplyPraiseList(
            CmReplyPraiseListRequest request);

    /**
     * 保存CmReplyPraise
     * 
     * @param request
     *            CmReplyPraise请求
     * @return 保存CmReplyPraise响应
     */
    CmReplyPraiseResponse addCmReplyPraise(CmReplyPraiseRequest request);

    /**
     * 删除CmReplyPraise通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmReplyPraise响应
     */
    CmReplyPraiseResponse deleteCmReplyPraiseById(Integer id);

    /**
     * 修改CmReplyPraise
     * 
     * @param request
     *            修改CmReplyPraise请求
     * @return 修改CmReplyPraise响应
     */
    CmReplyPraiseResponse updateCmReplyPraise(
            CmReplyPraiseRequest request);

    /**
     * 通过ID获取CmReplyPraise
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmReplyPraise响应
     */
    CmReplyPraiseResponse getCmReplyPraiseById(Integer id);
}
