/**
 * Description: CmRemoveGoodsWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmRemoveGoodsListRequest;
import com.house365.ws.beans.request.CmRemoveGoodsRequest;
import com.house365.ws.beans.response.CmRemoveGoodsListResponse;
import com.house365.ws.beans.response.CmRemoveGoodsResponse;


/**
 * CmRemoveGoodsWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmRemoveGoods extends IService{

    /**
     * CmRemoveGoods列表查询
     * 
     * @param request
     *            CmRemoveGoods列表查询请求
     * @return CmRemoveGoods列表查询响应
     */
    CmRemoveGoodsListResponse getCmRemoveGoodsList(
            CmRemoveGoodsListRequest request);

    /**
     * 保存CmRemoveGoods
     * 
     * @param request
     *            CmRemoveGoods请求
     * @return 保存CmRemoveGoods响应
     */
    CmRemoveGoodsResponse addCmRemoveGoods(CmRemoveGoodsRequest request);

    /**
     * 删除CmRemoveGoods通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmRemoveGoods响应
     */
    CmRemoveGoodsResponse deleteCmRemoveGoodsById(Integer id);

    /**
     * 修改CmRemoveGoods
     * 
     * @param request
     *            修改CmRemoveGoods请求
     * @return 修改CmRemoveGoods响应
     */
    CmRemoveGoodsResponse updateCmRemoveGoods(
            CmRemoveGoodsRequest request);

    /**
     * 通过ID获取CmRemoveGoods
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmRemoveGoods响应
     */
    CmRemoveGoodsResponse getCmRemoveGoodsById(Integer id);
}
