/**
 * Description: CmPromotionConfigWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 上午 10:52:47
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmPromotionConfigListRequest;
import com.house365.ws.beans.request.CmPromotionConfigRequest;
import com.house365.ws.beans.response.CmPromotionConfigListResponse;
import com.house365.ws.beans.response.CmPromotionConfigResponse;


/**
 * CmPromotionConfigWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
public interface ICmPromotionConfig extends IService{

    /**
     * CmPromotionConfig列表查询
     * 
     * @param request
     *            CmPromotionConfig列表查询请求
     * @return CmPromotionConfig列表查询响应
     */
    CmPromotionConfigListResponse getCmPromotionConfigList(
        CmPromotionConfigListRequest request
    );

    /**
     * 保存CmPromotionConfig
     * 
     * @param request
     *            CmPromotionConfig请求
     * @return 保存CmPromotionConfig响应
     */
    CmPromotionConfigResponse addCmPromotionConfig(CmPromotionConfigRequest request);

    /**
     * 删除CmPromotionConfig通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmPromotionConfig响应
     */
    CmPromotionConfigResponse deleteCmPromotionConfigById(Integer id);

    /**
     * 修改CmPromotionConfig
     * 
     * @param request
     *            修改CmPromotionConfig请求
     * @return 修改CmPromotionConfig响应
     */
    CmPromotionConfigResponse updateCmPromotionConfig(
        CmPromotionConfigRequest request
    );

    /**
     * 通过ID获取CmPromotionConfig
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmPromotionConfig响应
     */
    CmPromotionConfigResponse getCmPromotionConfigById(Integer id);
}
