/**
 * Description: CmProductStatWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-03-16 下午 17:11:49
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-03-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmProductStatEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmProductStatListRequest;
import com.house365.ws.beans.request.CmProductStatRequest;
import com.house365.ws.beans.response.CmProductStatListResponse;
import com.house365.ws.beans.response.CmProductStatResponse;

import java.util.List;


/**
 * CmProductStatWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-03-16
 * @see
 * @since 1.0
 */
public interface ICmProductStat extends IService{

    void saveOrUpdate(CmCreditGoodsEntity goodsEntity);

    void refreshTask();

    /**
     * CmProductStat列表查询
     * 
     * @param request
     *            CmProductStat列表查询请求
     * @return CmProductStat列表查询响应
     */
    CmProductStatListResponse getCmProductStatList(
        CmProductStatListRequest request
    );

    /**
     * 保存CmProductStat
     * 
     * @param request
     *            CmProductStat请求
     * @return 保存CmProductStat响应
     */
    CmProductStatResponse addCmProductStat(CmProductStatRequest request);

    /**
     * 删除CmProductStat通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmProductStat响应
     */
    CmProductStatResponse deleteCmProductStatById(Integer id);

    /**
     * 修改CmProductStat
     * 
     * @param request
     *            修改CmProductStat请求
     * @return 修改CmProductStat响应
     */
    CmProductStatResponse updateCmProductStat(
        CmProductStatRequest request
    );

    /**
     * 通过ID获取CmProductStat
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmProductStat响应
     */
    CmProductStatResponse getCmProductStatById(Integer id);

    List<CmProductStatEntity> statByCity();

    List<CmProductStatEntity> statByDate(String cityName);
}
