/**
 * Description: CmHouseCommentWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:15
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.CmHouseCommentListRequest;
import com.house365.ws.beans.request.CmHouseCommentRequest;
import com.house365.ws.beans.response.CmHouseCommentListResponse;
import com.house365.ws.beans.response.CmHouseCommentResponse;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


/**
 * CmHouseCommentWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmHouseComment extends IService{

    /**
     * CmHouseComment列表查询
     * 
     * @param request
     *            CmHouseComment列表查询请求
     * @return CmHouseComment列表查询响应
     */
    CmHouseCommentListResponse getCmHouseCommentList(
            CmHouseCommentListRequest request);

    /**
     * 保存CmHouseComment
     * 
     * @param request
     *            CmHouseComment请求
     * @return 保存CmHouseComment响应
     */
    CmHouseCommentResponse addCmHouseComment(CmHouseCommentRequest request);

    /**
     * 删除CmHouseComment通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmHouseComment响应
     */
    CmHouseCommentResponse deleteCmHouseCommentById(Integer id);

    /**
     * 修改CmHouseComment
     * 
     * @param request
     *            修改CmHouseComment请求
     * @return 修改CmHouseComment响应
     */
    CmHouseCommentResponse updateCmHouseComment(
            CmHouseCommentRequest request);

    /**
     * 通过ID获取CmHouseComment
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmHouseComment响应
     */
    CmHouseCommentResponse getCmHouseCommentById(Integer id);

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    House365RestResponse checkHouseComment(String commentIds, String op) throws Exception;

    Integer deleteHouseComment(String id, String isNoTalk);

    void removeCache(Integer houseId);
}
