/**
 * Description: CmHouseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:14
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmHouseListRequest;
import com.house365.ws.beans.request.CmHouseRequest;
import com.house365.ws.beans.response.CmHouseListResponse;
import com.house365.ws.beans.response.CmHouseResponse;


/**
 * CmHouseWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmHouse extends IService{

    /**
     * CmHouse列表查询
     * 
     * @param request
     *            CmHouse列表查询请求
     * @return CmHouse列表查询响应
     */
    CmHouseListResponse getCmHouseList(
            CmHouseListRequest request);

    /**
     * 保存CmHouse
     * 
     * @param request
     *            CmHouse请求
     * @return 保存CmHouse响应
     */
    CmHouseResponse addCmHouse(CmHouseRequest request);

    /**
     * 删除CmHouse通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmHouse响应
     */
    CmHouseResponse deleteCmHouseById(Integer id);

    /**
     * 修改CmHouse
     * 
     * @param request
     *            修改CmHouse请求
     * @return 修改CmHouse响应
     */
    CmHouseResponse updateCmHouse(
            CmHouseRequest request);

    /**
     * 通过ID获取CmHouse
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmHouse响应
     */
    CmHouseResponse getCmHouseById(Integer id);

    CmHouseResponse increaseComment(Integer id);
}
