/**
 * Description: CmExchangeCodeBatchWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-03 下午 17:36:18
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-03   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmExchangeCodeBatchListRequest;
import com.house365.ws.beans.request.CmExchangeCodeBatchRequest;
import com.house365.ws.beans.response.CmExchangeCodeBatchListResponse;
import com.house365.ws.beans.response.CmExchangeCodeBatchResponse;


/**
 * CmExchangeCodeBatchWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-03
 * @see
 * @since 1.0
 */
public interface ICmExchangeCodeBatch extends IService{

    /**
     * CmExchangeCodeBatch列表查询
     * 
     * @param request
     *            CmExchangeCodeBatch列表查询请求
     * @return CmExchangeCodeBatch列表查询响应
     */
    CmExchangeCodeBatchListResponse getCmExchangeCodeBatchList(
            CmExchangeCodeBatchListRequest request);

    /**
     * 保存CmExchangeCodeBatch
     * 
     * @param request
     *            CmExchangeCodeBatch请求
     * @return 保存CmExchangeCodeBatch响应
     */
    CmExchangeCodeBatchResponse addCmExchangeCodeBatch(CmExchangeCodeBatchRequest request);

    /**
     * 删除CmExchangeCodeBatch通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmExchangeCodeBatch响应
     */
    CmExchangeCodeBatchResponse deleteCmExchangeCodeBatchById(Integer id);

    /**
     * 修改CmExchangeCodeBatch
     * 
     * @param request
     *            修改CmExchangeCodeBatch请求
     * @return 修改CmExchangeCodeBatch响应
     */
    CmExchangeCodeBatchResponse updateCmExchangeCodeBatch(
            CmExchangeCodeBatchRequest request);

    /**
     * 通过ID获取CmExchangeCodeBatch
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmExchangeCodeBatch响应
     */
    CmExchangeCodeBatchResponse getCmExchangeCodeBatchById(Integer id);
}
