/**
 * Description: CmExchangeCodeWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:13
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmExchangeCodeListRequest;
import com.house365.ws.beans.request.CmExchangeCodeRequest;
import com.house365.ws.beans.response.CmExchangeCodeListResponse;
import com.house365.ws.beans.response.CmExchangeCodeResponse;


/**
 * CmExchangeCodeWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmExchangeCode extends IService{

    /**
     * CmExchangeCode列表查询
     * 
     * @param request
     *            CmExchangeCode列表查询请求
     * @return CmExchangeCode列表查询响应
     */
    CmExchangeCodeListResponse getCmExchangeCodeList(
            CmExchangeCodeListRequest request);

    /**
     * 保存CmExchangeCode
     * 
     * @param request
     *            CmExchangeCode请求
     * @return 保存CmExchangeCode响应
     */
    CmExchangeCodeResponse addCmExchangeCode(CmExchangeCodeRequest request);

    /**
     * 删除CmExchangeCode通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmExchangeCode响应
     */
    CmExchangeCodeResponse deleteCmExchangeCodeById(Integer id);
    
    CmExchangeCodeResponse deleteByBatchCode(Integer batchId);

    /**
     * 修改CmExchangeCode
     * 
     * @param request
     *            修改CmExchangeCode请求
     * @return 修改CmExchangeCode响应
     */
    CmExchangeCodeResponse updateCmExchangeCode(
            CmExchangeCodeRequest request);

    /**
     * 通过ID获取CmExchangeCode
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmExchangeCode响应
     */
    CmExchangeCodeResponse getCmExchangeCodeById(Integer id);
}
