/**
 * Description: CmDictionaryWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-08-30 下午 13:46:00
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmDictionaryListRequest;
import com.house365.ws.beans.request.CmDictionaryRequest;
import com.house365.ws.beans.response.CmDictionaryListResponse;
import com.house365.ws.beans.response.CmDictionaryResponse;


/**
 * CmDictionaryWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
public interface ICmDictionary extends IService{

    /**
     * CmDictionary列表查询
     * 
     * @param request
     *            CmDictionary列表查询请求
     * @return CmDictionary列表查询响应
     */
    CmDictionaryListResponse getCmDictionaryList(
        CmDictionaryListRequest request
    );

    /**
     * 保存CmDictionary
     * 
     * @param request
     *            CmDictionary请求
     * @return 保存CmDictionary响应
     */
    CmDictionaryResponse addCmDictionary(CmDictionaryRequest request);

    /**
     * 删除CmDictionary通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmDictionary响应
     */
    CmDictionaryResponse deleteCmDictionaryById(Integer id);

    /**
     * 修改CmDictionary
     * 
     * @param request
     *            修改CmDictionary请求
     * @return 修改CmDictionary响应
     */
    CmDictionaryResponse updateCmDictionary(
        CmDictionaryRequest request
    );

    /**
     * 通过ID获取CmDictionary
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmDictionary响应
     */
    CmDictionaryResponse getCmDictionaryById(Integer id);
}
