/**
 * Description: CmDeliveryAddressWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:12
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmDeliveryAddressListRequest;
import com.house365.ws.beans.request.CmDeliveryAddressRequest;
import com.house365.ws.beans.response.CmDeliveryAddressListResponse;
import com.house365.ws.beans.response.CmDeliveryAddressResponse;


/**
 * CmDeliveryAddressWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmDeliveryAddress extends IService{

    /**
     * CmDeliveryAddress列表查询
     * 
     * @param request
     *            CmDeliveryAddress列表查询请求
     * @return CmDeliveryAddress列表查询响应
     */
    CmDeliveryAddressListResponse getCmDeliveryAddressList(
            CmDeliveryAddressListRequest request);

    /**
     * 保存CmDeliveryAddress
     * 
     * @param request
     *            CmDeliveryAddress请求
     * @return 保存CmDeliveryAddress响应
     */
    CmDeliveryAddressResponse addCmDeliveryAddress(CmDeliveryAddressRequest request);

    /**
     * 删除CmDeliveryAddress通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmDeliveryAddress响应
     */
    CmDeliveryAddressResponse deleteCmDeliveryAddressById(Integer id);

    /**
     * 修改CmDeliveryAddress
     * 
     * @param request
     *            修改CmDeliveryAddress请求
     * @return 修改CmDeliveryAddress响应
     */
    CmDeliveryAddressResponse updateCmDeliveryAddress(
            CmDeliveryAddressRequest request);

    /**
     * 通过ID获取CmDeliveryAddress
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmDeliveryAddress响应
     */
    CmDeliveryAddressResponse getCmDeliveryAddressById(Integer id);
}
