/**
 * Description: CmCreditRuleWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:11
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCreditRuleListRequest;
import com.house365.ws.beans.request.CmCreditRuleRequest;
import com.house365.ws.beans.response.CmCreditRuleListResponse;
import com.house365.ws.beans.response.CmCreditRuleResponse;


/**
 * CmCreditRuleWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmCreditRule extends IService{

    /**
     * CmCreditRule列表查询
     * 
     * @param request
     *            CmCreditRule列表查询请求
     * @return CmCreditRule列表查询响应
     */
    CmCreditRuleListResponse getCmCreditRuleList(
            CmCreditRuleListRequest request);

    /**
     * 保存CmCreditRule
     * 
     * @param request
     *            CmCreditRule请求
     * @return 保存CmCreditRule响应
     */
    CmCreditRuleResponse addCmCreditRule(CmCreditRuleRequest request);

    /**
     * 删除CmCreditRule通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmCreditRule响应
     */
    CmCreditRuleResponse deleteCmCreditRuleById(Integer id);

    /**
     * 修改CmCreditRule
     * 
     * @param request
     *            修改CmCreditRule请求
     * @return 修改CmCreditRule响应
     */
    CmCreditRuleResponse updateCmCreditRule(
            CmCreditRuleRequest request);

    /**
     * 通过ID获取CmCreditRule
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCreditRule响应
     */
    CmCreditRuleResponse getCmCreditRuleById(Integer id);
}
