/**
 * Description: CmCreditAddRecordWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:08
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCreditAddRecordListRequest;
import com.house365.ws.beans.request.CmCreditAddRecordRequest;
import com.house365.ws.beans.response.CmCreditAddRecordListResponse;
import com.house365.ws.beans.response.CmCreditAddRecordResponse;


/**
 * CmCreditAddRecordWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmCreditAddRecord extends IService{

    /**
     * CmCreditAddRecord列表查询
     * 
     * @param request
     *            CmCreditAddRecord列表查询请求
     * @return CmCreditAddRecord列表查询响应
     */
    CmCreditAddRecordListResponse getCmCreditAddRecordList(
            CmCreditAddRecordListRequest request);

    /**
     * 保存CmCreditAddRecord
     * 
     * @param request
     *            CmCreditAddRecord请求
     * @return 保存CmCreditAddRecord响应
     */
    CmCreditAddRecordResponse addCmCreditAddRecord(CmCreditAddRecordRequest request);

    /**
     * 删除CmCreditAddRecord通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmCreditAddRecord响应
     */
    CmCreditAddRecordResponse deleteCmCreditAddRecordById(Integer id);

    /**
     * 修改CmCreditAddRecord
     * 
     * @param request
     *            修改CmCreditAddRecord请求
     * @return 修改CmCreditAddRecord响应
     */
    CmCreditAddRecordResponse updateCmCreditAddRecord(
            CmCreditAddRecordRequest request);

    /**
     * 通过ID获取CmCreditAddRecord
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCreditAddRecord响应
     */
    CmCreditAddRecordResponse getCmCreditAddRecordById(Integer id);
}
