/**
 * Description: CmAssessScoreWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-12-29 上午 11:12:25
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmAssessScoreListRequest;
import com.house365.ws.beans.request.CmAssessScoreRequest;
import com.house365.ws.beans.response.CmAssessScoreListResponse;
import com.house365.ws.beans.response.CmAssessScoreResponse;


/**
 * CmAssessScoreWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
public interface ICmAssessScore extends IService{

    /**
     * CmAssessScore列表查询
     * 
     * @param request
     *            CmAssessScore列表查询请求
     * @return CmAssessScore列表查询响应
     */
    CmAssessScoreListResponse getCmAssessScoreList(
            CmAssessScoreListRequest request);

    /**
     * 保存CmAssessScore
     * 
     * @param request
     *            CmAssessScore请求
     * @return 保存CmAssessScore响应
     */
    CmAssessScoreResponse addCmAssessScore(CmAssessScoreRequest request);

    /**
     * 删除CmAssessScore通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmAssessScore响应
     */
    CmAssessScoreResponse deleteCmAssessScoreById(Integer id);

    /**
     * 修改CmAssessScore
     * 
     * @param request
     *            修改CmAssessScore请求
     * @return 修改CmAssessScore响应
     */
    CmAssessScoreResponse updateCmAssessScore(
            CmAssessScoreRequest request);

    /**
     * 通过ID获取CmAssessScore
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmAssessScore响应
     */
    CmAssessScoreResponse getCmAssessScoreById(Integer id);
}
