/**
 * Description: CmAssessWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-12-29 上午 11:12:24
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmAssessListRequest;
import com.house365.ws.beans.request.CmAssessRequest;
import com.house365.ws.beans.response.CmAssessListResponse;
import com.house365.ws.beans.response.CmAssessResponse;


/**
 * CmAssessWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
public interface ICmAssess extends IService{

    /**
     * CmAssess列表查询
     * 
     * @param request
     *            CmAssess列表查询请求
     * @return CmAssess列表查询响应
     */
    CmAssessListResponse getCmAssessList(
            CmAssessListRequest request);

    /**
     * 保存CmAssess
     * 
     * @param request
     *            CmAssess请求
     * @return 保存CmAssess响应
     */
    CmAssessResponse addCmAssess(CmAssessRequest request);

    /**
     * 删除CmAssess通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmAssess响应
     */
    CmAssessResponse deleteCmAssessById(Integer id);

    /**
     * 修改CmAssess
     * 
     * @param request
     *            修改CmAssess请求
     * @return 修改CmAssess响应
     */
    CmAssessResponse updateCmAssess(
            CmAssessRequest request);

    /**
     * 通过ID获取CmAssess
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmAssess响应
     */
    CmAssessResponse getCmAssessById(Integer id);

    void cleanRecordsJob();
}
