/**
 * Description: CmAddGoodsWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:04
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmAddGoodsListRequest;
import com.house365.ws.beans.request.CmAddGoodsRequest;
import com.house365.ws.beans.response.CmAddGoodsListResponse;
import com.house365.ws.beans.response.CmAddGoodsResponse;


/**
 * CmAddGoodsWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmAddGoods extends IService{

    /**
     * CmAddGoods列表查询
     * 
     * @param request
     *            CmAddGoods列表查询请求
     * @return CmAddGoods列表查询响应
     */
    CmAddGoodsListResponse getCmAddGoodsList(
            CmAddGoodsListRequest request);

    /**
     * 保存CmAddGoods
     * 
     * @param request
     *            CmAddGoods请求
     * @return 保存CmAddGoods响应
     */
    CmAddGoodsResponse addCmAddGoods(CmAddGoodsRequest request);

    /**
     * 删除CmAddGoods通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmAddGoods响应
     */
    CmAddGoodsResponse deleteCmAddGoodsById(Integer id);

    /**
     * 修改CmAddGoods
     * 
     * @param request
     *            修改CmAddGoods请求
     * @return 修改CmAddGoods响应
     */
    CmAddGoodsResponse updateCmAddGoods(
            CmAddGoodsRequest request);

    /**
     * 通过ID获取CmAddGoods
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmAddGoods响应
     */
    CmAddGoodsResponse getCmAddGoodsById(Integer id);
}
