package com.house365.ws.interfaces.server;

import com.house365.ws.beans.request.AttachmentListRequest;
import com.house365.ws.beans.request.AttachmentRequest;
import com.house365.ws.beans.response.AttachmentListResponse;
import com.house365.ws.beans.response.AttachmentResponse;

public interface IAttachmentInterface {

    /**
     * 查询附件列表
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentListResponse getAttachments(AttachmentListRequest request);

    /**
     * 获取单个Attachment
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentResponse getAttachment(Integer id);

    /**
     * 添加附件
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentResponse addAttachment(AttachmentRequest request);

    /**
     * 修改Attachment
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentResponse updateAttachment(AttachmentRequest request);

    /**
     * 删除Attachment
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param id
     * @return
     * @since
     */
    AttachmentResponse deleteAttachment(Integer id);

    /**
     * 修改临时 资源ID resourceId
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param tmpResourceId
     * @param resourceId
     * @since
     */
    void updateAttachmentByResourceId(Integer tmpResourceId, Integer resourceId);
    
    AttachmentResponse deleteByResourceId(Integer resourceId);
    
    AttachmentResponse updateAttachmentResourceId(Integer resourceId);
}
