/**
 * Description: CmSmsCodeWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-06 下午 14:00:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.rest;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmSmsCodeListRequest;
import com.house365.ws.beans.request.CmSmsCodeRequest;
import com.house365.ws.beans.response.CmSmsCodeListResponse;
import com.house365.ws.beans.response.CmSmsCodeResponse;


/**
 * CmSmsCodeWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-06
 * @see
 * @since 1.0
 */
public interface ICmSmsCode extends IService{

    /**
     * CmSmsCode列表查询
     * 
     * @param request
     *            CmSmsCode列表查询请求
     * @return CmSmsCode列表查询响应
     */
    CmSmsCodeListResponse getCmSmsCodeList(
            CmSmsCodeListRequest request);

    /**
     * 保存CmSmsCode
     * 
     * @param request
     *            CmSmsCode请求
     * @return 保存CmSmsCode响应
     */
    CmSmsCodeResponse addCmSmsCode(CmSmsCodeRequest request);

    /**
     * 删除CmSmsCode通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmSmsCode响应
     */
    CmSmsCodeResponse deleteCmSmsCodeById(Integer id);

    /**
     * 修改CmSmsCode
     * 
     * @param request
     *            修改CmSmsCode请求
     * @return 修改CmSmsCode响应
     */
    CmSmsCodeResponse updateCmSmsCode(
            CmSmsCodeRequest request);

    /**
     * 通过ID获取CmSmsCode
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmSmsCode响应
     */
    CmSmsCodeResponse getCmSmsCodeById(Integer id);
    /**
     * 发送短信
     * 
     * @param request 请求
     * @return CmSmsCode响应
     */
    CmSmsCodeResponse sendSms(CmSmsCodeRequest req);
    CmSmsCodeResponse getByPhone(CmSmsCodeRequest req);
    CmSmsCodeResponse modifyComplete(String phone);
}
