/**
 * Description: CmPromotionProductWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-08-26 下午 17:24:07
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-26   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.rest;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmPromotionProductListRequest;
import com.house365.ws.beans.request.CmPromotionProductRequest;
import com.house365.ws.beans.response.CmPromotionProductListResponse;
import com.house365.ws.beans.response.CmPromotionProductResponse;


/**
 * CmPromotionProductWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-26
 * @see
 * @since 1.0
 */
public interface ICmPromotionProduct extends IService{

    /**
     * CmPromotionProduct列表查询
     * 
     * @param request
     *            CmPromotionProduct列表查询请求
     * @return CmPromotionProduct列表查询响应
     */
    CmPromotionProductListResponse getCmPromotionProductList(
        CmPromotionProductListRequest request
    );

    /**
     * 保存CmPromotionProduct
     * 
     * @param request
     *            CmPromotionProduct请求
     * @return 保存CmPromotionProduct响应
     */
    CmPromotionProductResponse addCmPromotionProduct(CmPromotionProductRequest request);

    /**
     * 删除CmPromotionProduct通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmPromotionProduct响应
     */
    CmPromotionProductResponse deleteCmPromotionProductById(Integer id);

    /**
     * 修改CmPromotionProduct
     * 
     * @param request
     *            修改CmPromotionProduct请求
     * @return 修改CmPromotionProduct响应
     */
    CmPromotionProductResponse updateCmPromotionProduct(
        CmPromotionProductRequest request
    );

    /**
     * 通过ID获取CmPromotionProduct
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmPromotionProduct响应
     */
    CmPromotionProductResponse getCmPromotionProductById(Integer id);
}
