package com.house365.test;

import java.io.FileInputStream;
import java.io.IOException;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import com.house365.commons.system.HttpClientUtil;

public class UploadTest {

    public static void main(String[] args) throws JSONException, IOException {
        String url1 = "http://localhost:8080/house365-hmc-web/api/uploadImage/";
        String result = HttpClientUtil.uploadFile(url1, "E:/test/ee.jpg", null);
        System.out.println(result);
        JSONObject jsonObject = new JSONObject(result);
        System.out.println(jsonObject.getJSONObject("data").getString("picUrl"));
        
        String url2 = "http://localhost:8080/house365-hmc-web/api/uploadFile/";
        RestTemplate restTemplate = new RestTemplate();
        MultiValueMap<String, Object> params = new LinkedMultiValueMap<>();
        FileInputStream file = new FileInputStream("E:/test/ee.jpg");
        byte[] fileBytes = new byte[file.available()];
        file.read(fileBytes);
        ByteArrayResource fileResource = new ByteArrayResource(fileBytes) {
            @Override
            public String getFilename() {
                return "ee.jpg";
            }
        };

        params.add("fileData", fileResource);
        
        try {
            String response = restTemplate.postForObject(url2, params, String.class);
            System.out.println(response);
            JSONObject json = new JSONObject(response);
            System.out.println(json.getJSONObject("data").getString("picUrl"));
        } catch (RestClientException e) {
            e.printStackTrace();
        }
        
        file.close();
    }

}
