/**
 * Created by chengjianfang on 2015/3/10.
 */
var Tools = function ($) {
    /**
     * 添加链接内容验证方法
     * @param ctx 上下文（应用上下文）
     * @param $this 当前选中框
     * @param city 城市编码
     * @param isInit 是否初始化
     */
    var handleChangeLinkType = function (ctx, $this, city, isInit) {
        var $linkContLabel = $("#linkContLabel");
        var $linkContInput = $("#linkContInput");
        var $linkContDiv = $("#linkContDiv");
        var $newHouseIdInput = $("#newHouseIdInput");
        var $newHouseIdDiv = $("#newHouseIdDiv");
        var $newHouseInput = $("#newHouseInput");
        var $newHouseDiv = $("#newHouseDiv");
        var $selectedOption = $this.find("option:selected");
        var $checkUrl = $("#checkUrl");
        var desc = $selectedOption.attr("description");
        var selectedId = $this.val();
        $linkContDiv.hide();
        $newHouseDiv.hide();
        $newHouseIdDiv.hide();
        if (!city) {
            city = "1";
        }
        $linkContInput.removeClass("remoteJson");
        $linkContInput.removeAttr("remoteUrl");
        if (0 < $checkUrl.size()) {
            $checkUrl.remove();
        }
        if (!isInit) {
            $linkContInput.val("");
            $newHouseInput.val("");
            $newHouseIdInput.val("");
        }
        $newHouseIdInput.removeClass("required");
        switch (selectedId) {
            // 新房
            case "1":
                $newHouseIdInput.addClass("required");
                $newHouseDiv.show();
                $newHouseIdDiv.show();
                break;
            // URL
            case "2":
                $linkContInput.parent().append('<a href="#" id="checkUrl">检查</a>');
                $("#checkUrl").click(function () {
                    var url = $linkContInput.val();
                    if (url) {
                        window.open(url);
                    }
                });
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 快速专题
            case "3":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/checkTopic?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 二手房房源详情
            case "4":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/houseSell?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 小区详情页
            case "5":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/houseBlock?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 资讯
            case "6":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/checkNews?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 抽奖活动
            case "7":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/checkActivity?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            // 无链接
            case "8":
                break;
            // 租房房源详情
            case "9":
                $linkContInput.addClass("remoteJson");
                $linkContInput.attr("remoteUrl", ctx + "/api/houseRent?city=" + city + "&id=");
                showDesc(desc, $linkContLabel, $linkContInput, $linkContDiv);
                break;
            default :
                break;
        }
    };

    /**
     * 显示链接框
     * @param desc 描述
     * @param $label 链接框标题
     * @param $linkCont 链接框内容
     * @param $nextDiv 链接框所在DIV
     */
    var showDesc = function (desc, $label, $linkCont, $nextDiv) {
        if (desc) {
            $label.html(desc + '<span class="redStar">*</span>' + "：");
            $linkCont.attr("placeholder", desc);
            $linkCont.addClass("required");
            $nextDiv.show();
        } else {
            $label.html("");
            $linkCont.removeAttr("placeholder");
            $linkCont.removeClass("required");
            $nextDiv.hide();
        }
    }

    /**
     * 添加链接内容验证方法
     * @param ctx 上下文（应用上下文）
     * @param $this 当前选中框
     * @param city 城市编码
     * @param isInit 是否初始化
     */
    return {
        changeLinkType: function (ctx, $this, city, isInit) {
            handleChangeLinkType(ctx, $this, city, isInit);
        }
    };
}(window.jQuery);