<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/cmorder<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/cmorder">订单列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <a href="${ctx}/cmorder" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">订单号:</label>
                            <div class="controls">
                                <span class="inline">${entity.id}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">下单时间:</label>
                            <div class="controls">
                            	<span class="inline">
                            		<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                            	</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">商品名称:</label>
                            <div class="controls">
                                <span class="inline">${entity.goodsName}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">商品数量:</label>
                            <div class="controls">
                                <span class="inline">${entity.goodsAmount}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">商品类型:</label>
                            <div class="controls">
                               <span class="inline">
                               <c:if test="${entity.goodsType eq 1}">
                                   虚拟
                               </c:if>
								<c:if test="${entity.goodsType eq 0}">
                                    实物
                                </c:if>
                               &nbsp;</span>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">会员电话:</label>
                            <div class="controls">
                                <span class="inline">${entity.userPhone}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">收货人名称:</label>
                            <div class="controls">
                                <span class="inline">${entity.receiverName}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">收货人手机:</label>
                            <div class="controls">
                                <span class="inline">${entity.receiverPhone}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">收货地址:</label>
                            <div class="controls">
                                <span class="inline">${entity.receiverArea} &nbsp;${entity.receiverDetailAddress}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">邮编:</label>
                            <div class="controls">
                                <span class="inline">${entity.receiverZipCode}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">

                        <div class="span6 control-group">
                            <label class="control-label">状态:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${entity.orderStatus eq 0}">
                                        <span class="inline">未配送</span>
                                    </c:when>
                                    <c:when test="${entity.orderStatus eq 1}">
                                        <span class="inline">已完成</span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">---</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>

                    </div>

                    <div class="row-fluid deliverDiv">
                        <div class="span6 control-group">
                            <label class="control-label">收货方式:</label>
                            <div class="controls">
                                <select id="selectReceiveType" name="selectReceiveType" onchange="changeReceiveType(this);">
                                    <option value="1">快递</option>
                                    <option value="0">自提</option>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group" id="divExpressCompany">
                            <label class="control-label">快递公司:</label>
                            <div class="controls" class="expressModifyDiv">
                                <input type="text" id="entityExpressCompany" style="display:none;"
                                       name="entity.expressCompany"
                                       class="expressModifyDivInput"
                                       value="${entity.expressCompany}"/>
                                <span class="inline expressModifyDivSpan">${entity.expressCompany}&nbsp;</span>
                            </div>
                        </div>

                    </div>

                    <div class="row-fluid deliverDiv">
                        <div class="span6 control-group">
                            <label class="control-label" id="labelOrderNumber">运单号:</label>
                            <div class="controls">
                                <input class="expressModifyDivInput" type="text" id="entityOrderNumber"
                                       style="display:none;"
                                       name="entity.oerderNumber"
                                       value="${entity.oerderNumber}"/>
                                <span class="inline expressModifyDivSpan">${entity.oerderNumber}&nbsp;</span>
                                <button class="btn btn-success" type="button" id="modifyExpressBtn">修改</button>
                                <button class="btn btn-warning" type="button" id="saveExpressBtn">保存</button>
                            </div>
                        </div>
                    </div>

                    <c:if test="${null eq entity.expressCompany || '' eq entity.expressCompany}">
                        <div class="row-fluid">
                            <div class="span12 control-group" style="text-align:center;">
                                <div class="controls">
                                    <button class="btn btn-primary btn-large" type="button" id="deliverBtn">配送</button>
                                    <button class="btn btn-primary btn-large" type="button" id="firstSaveBtn">保存
                                    </button>
                                </div>
                            </div>
                        </div>
                    </c:if>

                </div>
            </div>
        </div>

</form>
<script type="text/javascript">
    //快递公司名称
    var globalExpressCompanyName;
    function changeReceiveType(target) {
        var typeVal = $(target).val();
        //快递
        if (typeVal == 1) {
            $("#divExpressCompany").show();
            $("#labelOrderNumber").text("运单号:");
            $("#entityExpressCompany").val(globalExpressCompanyName);
        } else {
            $("#divExpressCompany").hide();
            $("#labelOrderNumber").text("自提地点:");
            $("#entityExpressCompany").val("自提");
        }
    }

    function updateDeliver(callback) {
        //判断文本框是否OK

        var selectReceiveType = $("#selectReceiveType").val();
        var entityOrderNumber = $("#entityOrderNumber").val();
        var entityExpressCompany = $("#entityExpressCompany").val();
        var data = {"selectReceiveType": selectReceiveType,"id": "${entity.id}", orderNumber: entityOrderNumber, expressCompany: entityExpressCompany};
        $.post("${ctx}/cmorder/deliverUpdate", data, function (result) {
            result = eval("(" + result + ")");
            if (result.result) {
                alert("更新成功")
                if (callback) {
                    callback(1);
                }
            }
        });
    }
    $(function () {
        globalExpressCompanyName = $("#entityExpressCompany").val();
        //如果是自提，则隐藏
        if ($("#entityExpressCompany").val() == "自提") {
            $("#divExpressCompany").hide();
            $("#labelOrderNumber").text("自提地点:");
            $("#entityExpressCompany").val("自提");
            //默认选择城市
            $("#selectReceiveType").val("0");
            $('#selectReceiveType').trigger("chosen:updated");
        }
        $("#saveExpressBtn").hide();
        //修改按钮
        $("#modifyExpressBtn").click(function () {
            $("#modifyExpressBtn").hide();
            $("#saveExpressBtn").show();
            $(".expressModifyDivSpan").css('display', 'none');
            $(".expressModifyDivInput").css('display', 'inline');
        });
        //保存按钮
        $("#saveExpressBtn").click(function () {
            updateDeliver(function (result) {
                window.location.reload();
            });
        });

        <c:if test="${null eq entity.expressCompany || '' eq entity.expressCompany}">
        $(".deliverDiv").hide();
        $("#firstSaveBtn").hide();
        $("#deliverBtn").click(function () {
            $(".deliverDiv").show();
            $("#modifyExpressBtn").hide();
            $("#saveExpressBtn").hide();
            $(".expressModifyDivInput").css('display', 'inline');
            $(".expressModifyDivSpan").css('display', 'none');
            $("#firstSaveBtn").show();
            $("#deliverBtn").hide();
        });

        $("#firstSaveBtn").click(function () {
            updateDeliver(function (result) {
                window.location.reload();
            });
        });

        </c:if>

    });

</script>
</body>

</html>
