<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>楼盘详情</title>
    <style type="text/css">
        img {
            cursor: pointer;
        }

    </style>
    <script type="text/javascript" src="${ctx}/resources/customize/js/imageModal.js"></script>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/cmhousecomment<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/cmhousecomment">列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline">楼盘评价编辑</span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline">楼盘评价详情</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/cmhousecomment/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/cmhousecomment" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <%-- <a href="${ctx}/cmhousecomment/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a> --%>
                            <a href="${ctx}/cmhousecomment" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">楼盘编号:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.houseId"
                                               name="entity.houseId"
                                               value="${entity.houseId}"/>
                                        <font color="red"><form:errors path="cmHouseCommentVo.entity.houseId"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.houseId}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">楼盘名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.houseName"
                                               name="entity.houseName"
                                               value="${entity.houseName}"/>
                                        <font color="red"><form:errors path="cmHouseCommentVo.entity.houseName"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.houseName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">评论者编号:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.criticId"
                                               name="entity.criticId"
                                               value="${entity.criticId}"/>
                                        <font color="red"><form:errors path="cmHouseCommentVo.entity.criticId"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.criticId}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">评论者手机号:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.criticPhone"
                                               name="entity.criticPhone"
                                               value="${entity.criticPhone}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.criticPhone"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.criticPhone}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">评论者姓名:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.criticName"
                                               name="entity.criticName"
                                               value="${entity.criticName}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.criticName"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.criticName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">评论内容:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.criticContent"
                                               name="entity.criticContent"
                                               value="${entity.criticContent}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.criticContent"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.criticContent}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">图片:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.criticPictures"
                                               name="entity.criticPictures"
                                               value="${entity.criticPictures}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.criticPictures"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <%-- <span class="inline">${entity.criticPictures}&nbsp;</span> --%>
                                        <c:forEach items="${entity.picList}" var="pic">
                                            <img src="${pic}" class="commentImage" style="height: 50px" width="50px">
                                        </c:forEach>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">平均得分:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.averageScore"
                                               name="entity.averageScore"
                                               value="${entity.averageScore}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.averageScore"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.averageScore}&nbsp;分</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">评论日期:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.commentDateStr"
                                               name="entity.commentDateStr"
                                               value="<fmt:formatDate value='${entity.commentDate}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.commentDate"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline"><f:formatDate value='${entity.commentDate}'
                                                                           pattern='yyyy-MM-dd HH:mm:ss'/></span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">被赞次数:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.praiseAmount"
                                               name="entity.praiseAmount"
                                               value="${entity.praiseAmount}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.praiseAmount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.praiseAmount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">评论数:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.commentAmount"
                                               name="entity.commentAmount"
                                               value="${entity.commentAmount}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.commentAmount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.commentAmount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">是否加精:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.isExcellent"
                                               name="entity.isExcellent"
                                               value="${entity.isExcellent}"/>
                                        <font color="red"><form:errors
                                                path="cmHouseCommentVo.entity.isExcellent"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <c:if test="${0 eq entity.isExcellent}">否</c:if>
                                        <c:if test="${1 eq entity.isExcellent}">是</c:if>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">是否置顶:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.isSticked"
                                               name="entity.isSticked"
                                               value="${entity.isSticked}"/>
                                        <font color="red"><form:errors path="cmHouseCommentVo.entity.isSticked"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <c:if test="${0 eq entity.isSticked}">否</c:if>
                                        <c:if test="${1 eq entity.isSticked}">是</c:if>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">是否已读:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.isReaded"
                                               name="entity.isReaded"
                                               value="${entity.isReaded}"/>
                                        <font color="red"><form:errors path="cmHouseCommentVo.entity.isReaded"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <c:if test="${0 eq entity.isReaded}">否</c:if>
                                        <c:if test="${1 eq entity.isReaded}">是</c:if>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br/>
            <div class="house365Border">
                <div class="sectionTitle">
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <h5>新增</h5>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <h5>编辑</h5>
                        </c:when>
                        <c:otherwise>
                            <h5>回复列表<input type="button" style="float:right;" onclick="commentReplyAdd('${entity.id}')"
                                           <c:if test="${managerReplied eq 1}">disabled</c:if> value="回复"/></h5>
                        </c:otherwise>
                    </c:choose>
                </div>
                <table class="table table-striped table-advance table-hover">
                    <thead>
                    <tr>
                        <!-- <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox" onclick="checkAll(this)" /></th> -->
                        <th width="100">回复人</th>
                        <th width="100">回复内容</th>
                        <!-- <th width="100">点赞人数</th> -->
                        <th width="100">回复时间</th>
                        <c:if test="${needCheck}">
                            <th width="100">审核状态</th>
                        </c:if>
                        <th width="150">操作</th>
                    </tr>
                    </thead>
                    <c:forEach items="${cmHouseCommentReplys}" var="cmHouseCommentReply">
                        <tr<c:if test="${cmHouseCommentReply.isReplyByManager eq 1}"> style="color:blue"</c:if>>
                                <%-- <td nowrap="nowrap" style="text-align:center">
                                    <input type="checkbox" name="memberCheck" value="${cmHouseCommentReply.id}" onclick="checkMember(this)"/>
                                </td> --%>
                            <td nowrap="nowrap">
                                <c:if test="${null ne cmHouseCommentReply.criticName && '' ne cmHouseCommentReply.criticName}">
                                    <c:out value="${cmHouseCommentReply.criticName}"/>
                                </c:if>
                                <c:if test="${null eq cmHouseCommentReply.criticName || '' eq cmHouseCommentReply.criticName}">
                                    &nbsp;
                                </c:if>
                            </td>
                            <td>
                                <c:if test="${null ne cmHouseCommentReply.content && '' ne cmHouseCommentReply.content}">
                                    <c:out value="${cmHouseCommentReply.content}"/>
                                </c:if>
                                <c:if test="${null eq cmHouseCommentReply.content || '' eq cmHouseCommentReply.content}">
                                    &nbsp;
                                </c:if>
                            </td>
                                <%-- <td nowrap="nowrap">
                                        <c:if test="${null ne cmHouseCommentReply.praiseCount && '' ne cmHouseCommentReply.praiseCount}">
                                            <c:out value="${cmHouseCommentReply.praiseCount}" />
                                        </c:if>
                                        <c:if test="${null eq cmHouseCommentReply.praiseCount || '' eq cmHouseCommentReply.praiseCount}">
                                            &nbsp;
                                        </c:if>
                                </td> --%>
                            <td nowrap="nowrap">
                                <c:if test="${null ne cmHouseCommentReply.createTime && '' ne cmHouseCommentReply.createTime}">
                                    <f:formatDate value='${cmHouseCommentReply.createTime}'
                                                  pattern='yyyy-MM-dd HH:mm:ss'/>
                                </c:if>
                                <c:if test="${null eq cmHouseCommentReply.createTime || '' eq cmHouseCommentReply.createTime}">
                                    &nbsp;
                                </c:if>
                            </td>
                            <c:if test="${needCheck}">
                                <td nowrap="nowrap">
                                    <c:if test="${null ne cmHouseCommentReply.checkStatus}">
                                        <c:choose>
                                            <c:when test="${cmHouseCommentReply.checkStatus eq '0'}">
                                                未审核
                                            </c:when>
                                            <c:when test="${cmHouseCommentReply.checkStatus eq '1'}">
                                                已审核
                                            </c:when>
                                            <c:when test="${cmHouseCommentReply.checkStatus eq '2'}">
                                                审核未通过
                                            </c:when>
                                            <c:otherwise>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:if>
                                    <c:if test="${null eq cmHouseCommentReply.checkStatus}">
                                        已审核&nbsp;
                                    </c:if>
                                </td>
                            </c:if>
                            <td nowrap="nowrap">
                                    <%-- <i class="icon-edit pointer icon-large"
                                        onclick="window.location='${ctx}/cmhousecommentreply/${cmHouseCommentReply.id}?action=edit'"></i>
                                        &nbsp;&nbsp; --%>

                                <c:choose>
                                    <c:when test="${cmHouseCommentReply.checkStatus eq 0 or cmHouseCommentReply.checkStatus eq 2}">
                                        <a href="###"
                                           onclick="checkThis('${cmHouseCommentReply.id}')">审核</a>
                                    </c:when>
                                    <c:when test="${cmHouseCommentReply.isReplyByManager eq 1}">
                                        <i title="修改"
                                           class="icon-edit pointer icon-large"
                                           onclick="commentReplyUpdate('${cmHouseCommentReply.id}','${cmHouseCommentReply.content}')"> </i>
                                    </c:when>
                                    <c:otherwise>
                                    </c:otherwise>
                                </c:choose>
                                <i title="删除"
                                   class="icon-minus pointer icon-large"
                                   onclick="deleteById('${cmHouseCommentReply.id}')"> </i>
                            </td>
                        </tr>
                    </c:forEach>
                </table>
                <div class="row${fluid}">
                    <house365:pagination page="${page}"/>
                </div>

            </div>


        </div>
    </div>

</form>

<div id="checkDialog" title="提示:" style="display: none;">
    请选择审核操作, 已审核通过的记录选择审核不通过不会生效。
</div>

<script type="text/javascript" src="${static_common}/script/jquery-ui-1.11.4.custom/jquery-ui.min.js"></script>
<script type="text/javascript">

    var commentReplyAdd = function (commentId) {
        var replyCommentHtml = "<textarea id='managerReplyContent' style='width:500px;height:200px;' maxlength='500'></textarea>";
        House365Util.createModal("小编回复", replyCommentHtml, function () {
            var contentNew = $("#managerReplyContent").val();
            if (contentNew == "") {
                alert("回复不能为空");
                return;
            }
            $.ajax({
                url: '${ctx}/cmhousecommentreply/commentReply/add',
                data: {
                    commentId: commentId,
                    content: contentNew
                },
                type: "post",
                success: function () {
                    alert("回复成功");
                    window.location.reload();
                }
            });
        });
    }

    var commentReplyUpdate = function (id, content) {
        var replyCommentHtml = "<textarea id='managerReplyContent' style='width:500px;height:200px;' maxlength='500'>" + content + "</textarea>";
        House365Util.createModal("小编回复", replyCommentHtml, function () {
            var contentNew = $("#managerReplyContent").val();
            if (contentNew == "") {
                alert("回复不能为空");
                return;
            }
            $.ajax({
                url: '${ctx}/cmhousecommentreply/commentReply/update',
                data: {
                    id: id,
                    content: contentNew
                },
                type: "post",
                success: function () {
                    alert("修改成功");
                    window.location.reload();
                }
            });
        });
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('commentCheck').length; i++) {
                if (document.getElementsByName('commentCheck')[i].checked) {
                    selectedId += document.getElementsByName('commentCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除回复", "请至少选择一条回复!", function () {
            });
        }
        else {
            House365Util.createModal("删除回复", "确定要删除这些回复吗？", function () {
                $.ajax({
                    url: '${ctx}/cmhousecommentreply/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    function checkThis(commentId) {
        $("#checkDialog").dialog({
            height: 200,
            width: 450,
            modal: true,
            closeOnEscape: false,
            resizable: false,
            autoOpen: false,
            buttons: {
                "审核通过": function () {
                    $("#checkDialog").dialog("close");
                    $.ajax({
                        url: '${ctx}/cmhousecommentreply/check/' + commentId + "?op=pass",
                        type: "GET",
                        success: function () {
                            window.location.reload();
                        }
                    });
                },
                "审核不通过": function () {
                    $("#checkDialog").dialog("close");
                    $.ajax({
                        url: '${ctx}/cmhousecommentreply/check/' + commentId + "?op=forbid",
                        type: "GET",
                        success: function () {
                            window.location.reload();
                        }
                    });
                },
                "关闭": function () {
                    $("#checkDialog").dialog("close");
                }
            }
        }).dialog("open");
    }
</script>
</body>

</html>
