<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>淘房币规则列表</title>
    <link rel="stylesheet" href="${ctx}/resources/script/kindeditor4/themes/default/default.css">
    <script charset="utf-8" src="${ctx}/resources/script/kindeditor4/kindeditor.js"></script>
    <script charset="utf-8" src="${ctx}/resources/script/kindeditor4/lang/zh_CN.js"></script>
    <script charset="utf-8" src="${ctx}/resources/script/kindeditor4/plugins/code/prettify.js"></script>
    <link rel="stylesheet" href="${ctx}/resources/script/kindeditor4/plugins/code/prettify.css"/>
    <script type="text/javascript">
        var editor;
        KindEditor.ready(function (K) {
            editor = K.create('textarea[name="entity.description"]', {
                cssPath: '${ctx}/resources/script/kindeditor4/plugins/code/prettify.css',
                allowImageUpload: true,
                allowFileManager: true,
                fileManagerJson: '${ctx}/resources/script/kindeditor4/jsp/file_manager_json.jsp',
                uploadJson: '${ctx}/image/addSectionPic',
                items: [
                    'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
                    'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
                    'insertunorderedlist', '|', 'emoticons', 'image', 'link'],
                afterCreate: function () {
                    var self = this;

                    K.ctrl(document, 13, function () {
                        self.sync();

                        //document.forms['example'].submit();
                    });
                    K.ctrl(self.edit.doc, 13, function () {
                        self.sync();
                        //document.forms['example'].submit();
                        //showImg(obj);
                    });
                },
                afterBlur: function () {
                    this.sync();
                }
            });

//            editor.toolbar.hide();
            prettyPrint();

            <c:choose>
            <c:when test="${action=='create' || action=='edit'}">
            //启用插件
            editor.readonly(false);
            </c:when>
            <c:otherwise>
            //如果详情模式下，禁用插件
            editor.readonly(true);
            </c:otherwise>
            </c:choose>
        });


        $(function () {
            $("#entityCountCircle").val("${entity.countCircle}");
            /* $("#vipClick").trigger("click"); */
            $('#entityCountCircle').trigger("chosen:updated");
            <c:choose>
            <c:when test="${action=='create' || action=='edit'}">

            </c:when>
            <c:otherwise>
            $("#entityCountCircle").prop("disabled", true);
            </c:otherwise>
            </c:choose>
        });

    </script>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/cmcreditrule<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <input type="hidden" name="entity.isShow" value="${entity.isShow}"/>

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/cmcreditrule">淘房币规则列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/cmcreditrule/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/cmcreditrule" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/cmcreditrule/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/cmcreditrule" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">淘房币数量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.credits"
                                               name="entity.credits"
                                               class="required number"
                                               value="${entity.credits}"/>
                                        <font color="red"><form:errors path="cmCreditRuleVo.entity.credits"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.credits}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">淘房币规则名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.creditRuleName"
                                               name="entity.creditRuleName"
                                               class="required"
                                               value="${entity.creditRuleName}"/>
                                        <font color="red"><form:errors
                                                path="cmCreditRuleVo.entity.creditRuleName"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.creditRuleName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">周期:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${entity.id eq 8 || entity.id eq 12 || entity.id eq 10 || entity.id eq 11}">
                                        不限
                                    </c:when>
                                    <c:when test="${entity.id eq 1 || entity.id eq 9}">
                                        一天
                                    </c:when>
                                    <c:otherwise>
                                        <c:choose>
                                            <c:when test="${action=='create' || action=='edit'}">
                                                <select id="entityCountCircle"
                                                        name="entity.countCircle"
                                                        value="${entity.countCircle}">
                                                    <option value="9999999">不限</option>
                                                    <option value="1">一天</option>
                                                    <option value="7">一周</option>
                                                    <option value="30">一月</option>
                                                </select>
                                                <%-- <input type="text" id="entity.countCircle"
                                                    name="entity.countCircle"
                                                    value="${entity.countCircle}" /> --%>
                                                <font color="red">
                                                    <form:errors path="cmCreditRuleVo.entity.countCircle"/>
                                                </font>
                                            </c:when>
                                            <c:otherwise>
                                                <select id="entityCountCircle"
                                                        name="entity.countCircle"
                                                        value="${entity.countCircle}" readonly="readonly">
                                                    <option value="9999999">不限</option>
                                                    <option value="1">一天</option>
                                                    <option value="7">一周</option>
                                                    <option value="30">一月</option>
                                                </select>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">周期内最多奖励次数:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${entity.id eq 8 || entity.id eq 1 || entity.id eq 10 || entity.id eq 11 || entity.id eq 9}">
                                        1
                                    </c:when>
                                    <c:when test="${entity.id eq 12}">
                                        不限
                                    </c:when>
                                    <c:otherwise>
                                        <c:choose>
                                            <c:when test="${action=='create' || action=='edit'}">
                                                <input type="text" id="entity.countLimit"
                                                       name="entity.countLimit"
                                                       class="required number"
                                                       value="${entity.countLimit}"/>
                                                <font color="red"><form:errors
                                                        path="cmCreditRuleVo.entity.countLimit"/></font>
                                            </c:when>
                                            <c:otherwise>
                                                <span class="inline">${entity.countLimit}&nbsp;</span>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            活动参数设置(活动有效期内获得积分为基础积分*积分倍数)
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span3 control-group">
                            <label class="control-label">开始时间</label>
                            <div class="controls">

                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="datetime-picker small" name="entity.activeStartTime"
                                               dateLte="#activeEndTime" id="activeStartTime"
                                               value="<fmt:formatDate value='${entity.activeStartTime}' pattern='yyyy-MM-dd HH:mm:ss' />"
                                               date-format="yyyy-mm-dd hh:ii:ss" placeholder="开始时间"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline"><fmt:formatDate value='${entity.activeStartTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span3 control-group">
                            <label class="control-label">结束时间</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="datetime-picker small" name="entity.activeEndTime"
                                               id="activeEndTime"
                                               dateGte="#activeStartTime"
                                               value="<fmt:formatDate value='${entity.activeEndTime}' pattern='yyyy-MM-dd HH:mm:ss' />"
                                               date-format="yyyy-mm-dd hh:ii:ss" placeholder="结束时间"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline"><fmt:formatDate value='${entity.activeEndTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span3 control-group">
                            <label class="control-label">积分倍数</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="small" name="entity.activeWeight" id="activeWeight"
                                               value="${entity.activeWeight}" placeholder="积分倍数"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.activeWeight}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">淘房币规则说明:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
										<textarea id="entity.description"
                                                  name="entity.description"
                                                  style="width:300px; height:200px;">${entity.description}</textarea>
                                        <font color="red"><form:errors path="cmCreditRuleVo.entity.description"/></font>
                                    </c:when>
                                    <c:otherwise>
                                    	<textarea style="width:300px; height:200px;" class="required"
                                                  readonly="readonly" id="entity.description"
                                                  name="entity.description">
                                                ${entity.description}
                                        </textarea>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

</form>
</body>

</html>
