<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>淘房币明细列表</title>
    <style type="text/css">
        #filterForm input {
            margin-top: 3px;
        }

        #filterForm div {
            margin-top: 3px;
        }

    </style>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>淘房币明细列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/cmcreditrecord" method="get">
                <select name="search_EQ_ruleId" id="search_rule_id_select" value="">
                    <option value="">全部事件</option>
                    <option value="10">注册</option>
                    <option value="1">签到</option>
                    <option value="7">礼品兑换扣除积分</option>
                    <option value="8">邀请新用户注册</option>
                    <option value="2">楼盘点评功能</option>
                    <option value="12">楼盘点评加精</option>
                    <option value="11">头像上传</option>
                    <option value="9">抽奖获得</option>
                    <option value="15">抽奖扣除</option>
                    <option value="13">房博士提问</option>
                    <option value="14">微信活动</option>
                    <option value="15">抽奖扣除</option>
                    <option value="16">社区发帖/回帖</option>
                    <option value="17">房博士提问扣除</option>
                    <option value="18">送心意</option>
                    <option value="20">积分激励</option>
                    <!-- <option value="3">房源</option>
                    <option value="4">经纪人评论</option>
                    <option value="5">删除经纪人评论</option> -->
                    <!-- <option value="6">删除楼盘评论</option>
                     -->
                </select>
                <input type="text" class="span2 date datetime-picker" id="startTime"
                       placeholder="开始时间" value="${param['search_GTE_happenTime']}"
                       name="search_GTE_happenTime" title="开始时间" date-format="yyyy-mm-dd hh:ii:ss">
                <input type="text"
                       class="span2 date datetime-picker" placeholder="结束时间" title="结束时间"
                       value="${param['search_LTE_andHappenTime']}" id="endTime" date-format="yyyy-mm-dd hh:ii:ss"
                       name="search_LTE_andHappenTime">
                <input type="text" name="search_EQ_userId" value="${param['search_EQ_userId']}"
                       class="m-wrap small" placeholder="用户ID" title="用户手机号" style="height:20px;">
                <input type="text" name="search_LIKE_userName" value="${param['search_LIKE_userName']}"
                       class="m-wrap small" placeholder="用户名称" title="用户名称" style="height:20px;">
                <input type="text" name="search_EQ_userPhone" value="${param['search_EQ_userPhone']}"
                       class="m-wrap small" placeholder="用户手机号" title="用户手机号" style="height:20px;">
                <c:if test="${1 eq userRole}">
                    <select class="span2" style="width:220px;height: 20px" name="search_EQ_cityId" id="citySelect">
                        <option value="">不限(站点)</option>
                        <option value="zbu" <c:if
                                test="${param['search_EQ_cityId'] eq 'zbu' }"> selected="selected"</c:if>>事业部
                        </option>
                        <c:forEach items="${cityList}" var="city">
                            <option value="<c:out value="${city.code}"/>" <c:if
                                    test="${param['search_EQ_cityId'] eq city.code }"> selected="selected"</c:if>><c:out
                                    value="${city.name}"/></option>
                        </c:forEach>
                    </select>
                </c:if>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="search()" title="搜索"></i>
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <i class="icon-file icon-2x pointer"
                       onclick="$('#filterForm').attr('action','${ctx}/cmcreditrecord/exportExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/cmcreditrecord');"
                       title="导出Excel"></i>
                </div>
            </form>
        </div>
    </div>

    <div class="row${fluid}">
        <div class="span12 well">
            <div class="span3"></div>
            <div class="span2">
                <h4><a href="${ctx}/cmuser/remainingCreditsList" title="返回" class="btn btn-primary">人数合计：</a><span
                        class="badge badge-warning" style="font-weight:bold;font-size:16px;">${userCount} </span></h4>
            </div>
            <div class="span2">
                <h4> 汇总 ：<span class="badge badge-success"
                               style="font-weight:bold;font-size:16px;">${creditsCount}</span>&nbsp;淘房币</h4>
            </div>
            <div class="span5"></div>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="100">编号</th>
            <th width="100">用户昵称</th>
            <th width="100">用户手机号</th>
            <th width="100">事件名称</th>
            <th width="100">积分数量</th>
            <th width="100">城市</th>
            <th width="100">时间</th>
        </tr>
        </thead>
        <c:forEach items="${cmCreditRecords}" var="cmCreditRecord">
            <tr>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.id && '' ne cmCreditRecord.id}">
                        <c:out value="${cmCreditRecord.id}"/>
                    </c:if>

                    <c:if test="${null eq cmCreditRecord.id || '' eq cmCreditRecord.id}">
                        &nbsp;
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.userName && '' ne cmCreditRecord.userName}">
                        <a href="${ctx}/cmcreditrecord?search_EQ_userId=<c:out value="${cmCreditRecord.userId}" />">
                            <c:out value="${cmCreditRecord.userName}"/>
                        </a>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.userName || '' eq cmCreditRecord.userName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.userPhone && '' ne cmCreditRecord.userPhone}">
                        <a href="${ctx}/cmcreditrecord?search_EQ_userId=<c:out value="${cmCreditRecord.userId}" />">
                            <c:out value="${cmCreditRecord.userPhone}"/>
                        </a>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.userPhone || '' eq cmCreditRecord.userPhone}">
                        &nbsp;
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.ruleName && '' ne cmCreditRecord.ruleName}">
                        <c:out value="${cmCreditRecord.ruleName}"/>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.ruleName || '' eq cmCreditRecord.ruleName}">
                        &nbsp;
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.amount && '' ne cmCreditRecord.amount}">
                        <c:out value="${cmCreditRecord.amount}"/>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.amount || '' eq cmCreditRecord.amount}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.cityName && '' ne cmCreditRecord.cityName}">
                        <c:forEach items="${cityList}" var="city">
                            <c:if test="${cmCreditRecord.cityName eq city.code }">${city.name}</c:if>
                        </c:forEach>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.cityName || '' eq cmCreditRecord.cityName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCreditRecord.happenTime && '' ne cmCreditRecord.happenTime}">
                        <f:formatDate value='${cmCreditRecord.happenTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmCreditRecord.happenTime || '' eq cmCreditRecord.happenTime}">
                        &nbsp;
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //默认选择城市
    $("#search_rule_id_select").val("${param['search_EQ_ruleId']}");
    $('#search_rule_id_select').trigger("chosen:updated");


    function search(){
        var startDateStr = $('#startTime').val();
        var endDateStr = $('#endTime').val();
        if (startDateStr == '' || startDateStr == null || startDateStr == undefined) {
            if (endDateStr == '' || endDateStr == null || endDateStr == undefined) {
                alert("请选择查询开始时间和结束时间！");
                return false;
            }
        }

        $('#filterForm').submit();
    }


</script>
</body>
</html>
