<%@ page import="java.util.Date" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>商品列表</title>
    <style type="text/css">
        #filterForm input {
            margin-top: 3px;
        }

        #filterForm div {
            margin-top: 3px;
        }
    </style>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>商品列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm valid" action="${ctx}/cmcreditgoods" method="get">
                <input type="hidden" name="orderColumn" value="${param['orderColumn']}"/>
                <input type="hidden" name="orderMode" value="${param['orderMode']}"/>
                <input type="text" name="search_LIKE_goodsId" value="${param['search_LIKE_goodsId']}"
                       class="m-wrap small" placeholder="商品编码" style="height:20px;">
                <input type="text" name="search_LIKE_goodsName" value="${param['search_LIKE_goodsName']}"
                       class="m-wrap small" placeholder="商品名称" style="height:20px;">
                <c:if test="${1 eq userRole}">
                    <select class="span2" style="width:220px;height: 20px" name="search_EQ_cityKey" id="citySelect">
                        <option value="">不限(站点)</option>
                        <option value="zbu" <c:if
                                test="${param['search_EQ_cityKey'] eq 'zbu' }"> selected="selected"</c:if>>事业部
                        </option>
                        <c:forEach items="${cityList}" var="city">
                            <option value="<c:out value="${city.code}"/>" <c:if
                                    test="${param['search_EQ_cityKey'] eq city.code }"> selected="selected"</c:if>>
                                <c:out value="${city.name}"/></option>
                        </c:forEach>
                        <option value="fz" <c:if
                                test="${param['search_EQ_cityKey'] eq 'fz' }"> selected="selected"</c:if>>福州
                        </option>
                    </select>
                </c:if>
                <input type="text" class="datetime-picker span2 small" name="search_GTE_startUpdateTime"
                       dateLte="#endUpdateTimeInput" id="startUpdateTimeInput"
                       value="${param['search_GTE_startUpdateTime']}" date-format="yyyy-mm-dd hh:ii:ss"
                       placeholder="开始时间"/>

                <input type="text" class="datetime-picker span2 small" name="search_LTE_endUpdateTime"
                       id="endUpdateTimeInput" dateGte="#startUpdateTimeInput"
                       value="${param['search_LTE_endUpdateTime']}" date-format="yyyy-mm-dd hh:ii:ss"
                       placeholder="结束时间"/>
                <select class="m-wrap small" name="search_EQ_status"
                        data-placeholder="不限(状态)" style="width:220px; height: 20px">
                    <option value="" selected="selected">状态(不限)</option>
                    <option value="0" <c:if test="${param['search_EQ_status'] eq '0' }"> selected="selected"</c:if>>
                        已上架
                    </option>
                    <option value="1" <c:if test="${param['search_EQ_status'] eq '1' }"> selected="selected"</c:if>>
                        未上架
                    </option>
                </select>
                <select class="m-wrap small" name="search_EQ_goodsType"
                        data-placeholder="不限(商品类型)" style="width:220px; height: 20px">
                    <option value="" selected="selected">商品类型(不限)</option>
                    <option value="0" <c:if test="${param['search_EQ_goodsType'] eq '0' }"> selected="selected"</c:if>>
                        实物商品
                    </option>
                    <option value="1" <c:if test="${param['search_EQ_goodsType'] eq '1' }"> selected="selected"</c:if>>
                        虚拟商品
                    </option>
                    <option value="2" <c:if test="${param['search_EQ_goodsType'] eq '2' }"> selected="selected"</c:if>>
                        第三方商品
                    </option>
                </select>
                <select class="m-wrap small" name="search_EQ_isSeckill"
                        data-placeholder="不限(是否为秒杀)" style="width:220px; height: 20px">
                    <option value="" selected="selected">是否为秒杀(不限)</option>
                    <option value="0" <c:if test="${param['search_EQ_isSeckill'] eq '0' }"> selected="selected"</c:if>>
                        普通商品
                    </option>
                    <option value="1" <c:if test="${param['search_EQ_isSeckill'] eq '1' }"> selected="selected"</c:if>>
                        秒杀商品
                    </option>
                </select>
                <!--
                    <select name="entity.goodsType" id="entity.goodsType" class="span3" data-placeholder="商品类型">
						<option value="" selected></option>
						<c:forEach items="${originSelectList}" var="originSelect">
							<option value="${originSelect.originId}"
								<c:if test="${fn:contains(search_LIKE_originId,originSelect.originId)}">selected="selected"</c:if>>${entity.goodsType}
							</option>
						</c:forEach>
					</select>
				-->
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/cmcreditgoods/updateSortList" class="btn blue pull-right" title="排序"><i
                            class="icon-list"></i></a>
                </div>
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/cmcreditgoods?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="100" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                             onclick="checkAll(this)"/></th>
            <th width="100">ID</th>
            <th width="100">编码</th>
            <th width="100">商品名称</th>
            <th width="100">商品类型</th>
            <th width="100">是否为秒杀</th>
            <th width="100">被锁定数量</th>
            <th width="100">当前秒杀活动兑换数量</th>
            <th width="100" style="cursor:pointer;" onclick="sortBy('credits_needed','
            <c:if test="${param['orderMode'] eq 'desc'}">asc</c:if>
            <c:if test="${param['orderMode'] eq 'asc' || empty param['orderMode']}">desc</c:if>')">淘房币数↑↓
            </th>
            <th width="100" style="cursor:pointer;" onclick="sortBy('stock','
            <c:if test="${param['orderMode'] eq 'desc'}">asc</c:if>
            <c:if test="${param['orderMode'] eq 'asc' || empty param['orderMode']}">desc</c:if>')">库存↑↓
            </th>
            <th width="100" style="cursor:pointer;" onclick="sortBy('exchanged_count','
            <c:if test="${param['orderMode'] eq 'desc'}">asc</c:if>
            <c:if test="${param['orderMode'] eq 'asc' || empty param['orderMode']}">desc</c:if>')">销量↑↓
            </th>
            <th width="100">状态</th>
            <th width="100">组织</th>
            <th width="100">更新时间</th>
            <th width="10">排序值</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:if test="${empty cmCreditGoods && !isFirst}">
            <tr>
                <td colspan="10" style="text-align: center;">
                    <font color="red">未找到商品信息</font>
                </td>
            </tr>
        </c:if>
        <c:if test="${!empty cmCreditGoods}">
            <c:forEach items="${cmCreditGoods}" var="creditGoods">
                <tr>
                    <td nowrap="nowrap" style="text-align:center">
                        <input type="checkbox" name="memberCheck" value="${creditGoods.id}"
                               onclick="checkMember(this)"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.id}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.goodsId}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.goodsName}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:choose>
                            <c:when test="${creditGoods.goodsType==1}">
                                虚拟商品
                            </c:when>
                            <c:when test="${creditGoods.goodsType==2}">
                                第三方商品
                            </c:when>
                            <c:otherwise>实物商品 <span class="inline">${entity.exchangeProcess}&nbsp;</span>
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td nowrap="nowrap">
                        <c:set var="nowDate" value="<%=new Date()%>">
                        </c:set>
                        <c:choose>
                            <c:when test="${creditGoods.isSeckill==1}">
                                <c:if test="${creditGoods.seckillEndTime < nowDate}">
                                    <strong style="color:red;">秒杀商品(过期)</strong>
                                </c:if>
                                <c:if test="${creditGoods.seckillEndTime >= nowDate}">
                                    <strong style="color:red;">秒杀商品</strong>
                                </c:if>
                            </c:when>
                            <c:otherwise>
                                普通商品
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td nowrap="nowrap">
                        <c:choose>
                            <c:when test="${creditGoods.isSeckill==1}">
                                <strong style="color:red;">${creditGoods.seckillStock}</strong>
                            </c:when>
                            <c:otherwise>
                                --
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td nowrap="nowrap">
                        <c:choose>
                            <c:when test="${creditGoods.isSeckill==1}">
                                <strong style="color:red;">${creditGoods.seckillOrderCount}</strong>
                            </c:when>
                            <c:otherwise>
                                --
                            </c:otherwise>
                        </c:choose>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.creditsNeeded}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.stock}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.exchangedCount}"/>
                    </td>
                    <td nowrap="nowrap">
                        <c:if test="${0 eq creditGoods.status}">
                            上架
                        </c:if>
                        <c:if test="${1 eq creditGoods.status}">
                            未上架
                        </c:if>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.cityName}"/>
                    </td>

                    <td nowrap="nowrap">
                        <fmt:formatDate value="${creditGoods.updateTime}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
                            <%-- <c:out value="${creditGoods.createTime}" /> --%>
                    </td>
                    <td nowrap="nowrap">
                        <c:out value="${creditGoods.sortValue}"/>
                    </td>
                    <td nowrap="nowrap">
                        <i class="icon-arrow-up pointer icon-large"
                           <c:if test="${1 eq creditGoods.status}">onclick="shelves('up','${creditGoods.id}')"</c:if>
                           title="上架"></i>
                        &nbsp;&nbsp;
                        <i class="icon-arrow-down pointer icon-large"
                           <c:if test="${0 eq creditGoods.status}">onclick="shelves('down','${creditGoods.id}')"</c:if>
                           title="下架"></i>
                        &nbsp;&nbsp;
                        <i class="icon-file pointer icon-large" onclick="viewGoodsDetail('${creditGoods.id}')"
                           title="查看"></i>
                        &nbsp;&nbsp;
                        <i class="icon-minus pointer icon-large"
                           <c:if test="${1 eq creditGoods.status}">onclick="deleteById('${creditGoods.id}')"</c:if>
                           title="删除"></i>
                    </td>
                </tr>
            </c:forEach>
        </c:if>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除", "请至少选择一条数据!", function () {
            });
        }
        else {
            House365Util.createModal("删除", "确定要删除该数据？", function () {
                $.ajax({
                    url: '${ctx}/cmcreditgoods/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    var shelves = function (ud, selectedId) {
        if (ud == "up") {
            House365Util.createModal("上架", "确认上架?", function () {
                $.ajax({
                    url: '${ctx}/cmcreditgoods/shelves/' + ud + '/' + selectedId,
                    type: "GET",
                    success: function (data) {
                        window.location.reload();
                    }
                });
            });
        }
        if (ud == "down") {
            House365Util.createModal("下架", "确认下架?", function () {
                $.ajax({
                    url: '${ctx}/cmcreditgoods/shelves/' + ud + '/' + selectedId,
                    type: "GET",
                    success: function (data) {
                        window.location.reload();
                    }
                });
            });
        }

    };

    var viewGoodsDetail = function (selectedId) {
        window.location.href = "${ctx}/cmcreditgoods/" + selectedId;
    };

    //排序
    function sortBy(column, mode) {
        $("form input[name='orderColumn']").val(column);
        $("form input[name='orderMode']").val(mode);
        $('#filterForm').submit();
    }

</script>
</body>
</html>
