<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/cmcreditgoods<c:if test="${action=='edit'}">/${entity.id}</c:if>" method="post">
    <input type="hidden" name="entity.indexPicture" class="indexPictureHidden" value=""/>
    <input type="hidden" name="entity.detailPicture" class="detailPictureHidden" value=""/>
    <input type="hidden" name="entity.listPicture" class="listPictureHidden" value=""/>
    <input type="hidden" name="entity.smallListPicture" class="smallListPictureHidden" value=""/>
    <input type="hidden" id="entity.status" name="entity.status" value="${entity.status}"/>
    <input type="hidden" id="entity.cityId" name="entity.cityId" value="${entity.cityId}"/>
    <input type="hidden" id="entity.cityName" name="entity.cityName" value="${entity.cityName}"/>
    <input type="hidden" id="entity.cityKey" name="entity.cityKey" value="${entity.cityKey}"/>
    <input type="hidden" id="entity.updateTimeStr" name="entity.updateTimeStr"
           value="<fmt:formatDate value='${entity.updateTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
    <input type="hidden" id="entity.createTimeStr" name="entity.createTimeStr"
           value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
    <input type="hidden" id="entity.isDeleted" name="entity.isDeleted" value="${entity.isDeleted}"/>
    <input type="hidden" id="sign" name="sign" value=""/>
    <input type="hidden" id="entityIsSeckill" name="entity.isSeckill" value="${entity.isSeckill}"/>

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/cmcreditgoods">列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="button" id="up" onclick="submitForm(this)"><i
                                    class="icon-save"></i>&nbsp;上架
                            </button>
                            <button class="btn blue" type="button" id="save" onclick="submitForm(this)"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/cmcreditgoods/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue" type="button" id="up" onclick="submitForm(this)"><i
                                    class="icon-save"></i>&nbsp;上架
                            </button>
                            <button class="btn blue" type="button" id="save" onclick="submitForm(this)"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/cmcreditgoods" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="javascript:editGoods();" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/cmcreditgoods" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border" style="height:auto;"> <!-- house365Border1 start-->
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="uniquePageKey" type="hidden" value="${uniquePageKey}"/>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">商品类型：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <select class="m-wrap small goodsType" name="entity.goodsType"
                                                id="entity.goodsType" data-placeholder="商品类型">
                                            <option value="1" selected="selected">虚拟商品</option>
                                            <option value="0">实物商品</option>
                                            <option value="2">第三方商品</option>
                                        </select>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.goodsType"/></font>
                                    </c:when>
                                    <c:when test="${ action=='edit'}">
                                        <input name="entity.goodsType" value="${entity.goodsType}" type="hidden"/>
                                        <c:if test="${entity.goodsType eq 1 }">虚拟商品</c:if>
                                        <c:if test="${entity.goodsType eq 0 }">实物商品</c:if>
                                        <c:if test="${entity.goodsType eq 2 }">第三方商品</c:if>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.goodsType"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                        	<c:if test="${0 eq entity.goodsType}">
                                                实物商品
                                            </c:if>
                                        	<c:if test="${1 eq entity.goodsType}">
                                                虚拟商品
                                            </c:if>
                                        	<c:if test="${2 eq entity.goodsType}">
                                                第三方商品
                                            </c:if>
                                        &nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>

                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">商品名称：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="goodsName required" maxlength="30"
                                               id="entity.goodsName"
                                               name="entity.goodsName"
                                               value="${entity.goodsName}" onblur="removeError()"/>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.goodsName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">商品编码：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <input type="text" class="goodsId required" id="entity.goodsId"
                                               name="entity.goodsId"
                                               value="${entity.goodsId}" onblur="removeError()"/>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.goodsId"/></font>
                                    </c:when>
                                    <c:when test="${ action=='edit'}">
                                        ${entity.goodsId}
                                        <input type="hidden" id="entity.goodsId"
                                               name="entity.goodsId"
                                               value="${entity.goodsId}"/>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.goodsId"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.goodsId}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">首页图片(592*198)：</label>
                            <div class="controls">
                                <input id="indexPicture" type="hidden" class=""/>
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="indexPicture" editAble="true" title="首页图片"
                                                           maxSize="1" isCreate="true"/>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="indexPicture" editAble="true" title="首页图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:when>
                                    <c:otherwise>
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="indexPicture" editAble="false" title="首页图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">详情大图(640*260)：</label>
                            <div class="controls">
                                <input id="detailPicture" type="hidden"/>
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="detailPicture" editAble="true" title="详情大图"
                                                           maxSize="1" isCreate="true"/>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="detailPicture" editAble="true" title="详情大图"
                                                           maxSize="1" isCreate="false"/>
                                    </c:when>
                                    <c:otherwise>
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="detailPicture" editAble="false" title="详情大图"
                                                           maxSize="1" isCreate="false"/>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">列表图片(282*116)：</label>
                            <div class="controls">
                                <input id="listPicture" type="hidden"/>
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="listPicture" editAble="true" title="列表图片"
                                                           maxSize="1" isCreate="true"/>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="listPicture" editAble="true" title="列表图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:when>
                                    <c:otherwise>
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="listPicture" editAble="false" title="列表图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">订单图片(190*124)：</label>
                            <div class="controls">
                                <input id="smallListPicture" type="hidden"/>
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="smallListPicture" editAble="true" title="订单图片"
                                                           maxSize="1" isCreate="true"/>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="smallListPicture" editAble="true" title="订单图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:when>
                                    <c:otherwise>
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="smallListPicture" editAble="false" title="订单图片"
                                                           maxSize="1" isCreate="false"/>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">兑换淘房币(个)：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="creditsNeeded required" id="entity.creditsNeeded"
                                               name="entity.creditsNeeded"
                                               value="${entity.creditsNeeded}" maxlength="9"
                                               onKeyUp="this.value=this.value.replace(/\D/g,'')"
                                               onafterpaste="this.value=this.value.replace(/\D/g,'')"
                                               onblur="removeError()"/>
                                        <font color="red"><form:errors
                                                path="cmCreditGoodsVo.entity.creditsNeeded"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.creditsNeeded}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">市场价(元)：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="price required" id="entity.price"
                                               name="entity.price"
                                               value="${entity.price}" maxlength="9"
                                               onKeyUp="this.value=this.value.replace(/\D/g,'')"
                                               onafterpaste="this.value=this.value.replace(/\D/g,'')"
                                               onblur="removeError()"/>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.price"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.price}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid" id="singleDiv3">
                        <div class="span6 control-group">
                            <label class="control-label">库存(个)：</label>
                            <div class="controls">

                                <c:choose>
                                    <c:when test="${(action=='create' || action=='edit') && entity.goodsType!=1}">
                                        <input type="text" class="stock required" id="entityStock"
                                               name="entity.stock"
                                               value="${entity.stock}" maxlength="9"
                                               onKeyUp="this.value=this.value.replace(/\D/g,'')"
                                               onafterpaste="this.value=this.value.replace(/\D/g,'')"
                                               onblur="removeError()"/>
                                        <font color="red"><form:errors path="cmCreditGoodsVo.entity.stock"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <input type="text" readonly="readonly" name="entity.stock"
                                               value="${entity.stock}">
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div id="thirdParty" style="display: none">
                        <div class="row-fluid">
                            <div class="span6 control-group">
                                <label class="control-label">自动下架时间：</label>
                                <div class="controls">
                                    <c:choose>
                                        <c:when test="${action=='create' || action=='edit'}">
                                            <div class="span10 input-append date datetime-picker" id="autoSoldout"
                                                 data-date-format="yyyy-mm-dd HH:mm:ss" >
                                                <input class="span10 autoSoldoutDate" type="text"
                                                       id="autoSoldoutDate"
                                                       name="entity.autoSoldoutDate"
                                                       placeholder="自动下架日期"
                                                       onFocusout="removeErrorLabel()"
                                                value="<fmt:formatDate value='${entity.autoSoldoutDate}' pattern='yyyy-MM-dd HH:mm:ss' />"
                                                <span class="add-on"><i class="icon-remove"></i></span>
                                                <span class="add-on"><i class="icon-calendar"></i></span>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                        <span class="inline">
                                        	<fmt:formatDate value='${entity.autoSoldoutDate}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        &nbsp;</span>
                                        </c:otherwise>
                                    </c:choose>

                                </div>
                            </div>
                            <div class="span6 control-group">
                                <label class="control-label">第三方领取商品链接：</label>
                                <div class="controls">
                                    <c:choose>
                                        <c:when test="${action=='create' || action=='edit'}">
                                            <div class="span10 input-append" id="autoSoldout" >
                                                <input class="span10" type="text" id="thirdLink" name="entity.thirdLink"
                                                       placeholder="第三方领取商品链接" onFocusout="removeErrorLabel()"
                                                       value='${entity.thirdLink}'/>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                        <span class="inline">
                                        	${entity.thirdLink}
                                        &nbsp;</span>
                                        </c:otherwise>
                                    </c:choose>

                                </div>
                            </div>
                        </div>

                    </div>
                    <%-- 	<c:if test="${action=='edit' &&  0 eq entity.goodsType}">
                            <div class="row-fluid" id="replenishmentDiv">
                                <div class="span6 control-group">
                                    <label class="control-label">补货：</label>
                                    <div class="controls">
                                        <c:choose>
                                            <c:when test="${action=='edit'}">
                                                <input type="text" id="replenishment" name="replenishment" value="" maxlength="9"
                                                onKeyUp="this.value=this.value.replace(/\D/g,'')" onafterpaste="this.value=this.value.replace(/\D/g,'')" onblur="removeError()"/>
                                            </c:when>
                                            <c:otherwise>
                                                <span class="inline">&nbsp;</span>
                                            </c:otherwise>
                                        </c:choose>
                                    </div>
                                </div>
                            </div>
                        </c:if> --%>

                    <!-- 虚拟商品属性 start -->
                    <div id="singleDiv">
                        <div class="row-fluid">
                            <div class="span6 control-group">
                                <label class="control-label">兑换码：</label>
                                <div class="controls">
                                    <c:choose>
                                        <c:when test="${action=='create' || action=='edit'}">
                                            <label class="span4 btn_label" id="upload" for="consultant_file">
                                                <i class="icon-cloud-upload pointer  icon-large"></i>&nbsp;&nbsp;&nbsp;&nbsp;选择
                                            </label>
                                            <input type="file"
                                                   id="consultant_file" name="consultant_file" value=""
                                                   class="imageValid" placeholder="请导入名单" title="请选择上传文件"
                                                   accept="application/vnd.ms-excel" style="display: none"/> <input
                                                type="hidden" id="code_msg" name="code_msg" value="">
                                            <div id="latestBatchNameSpan"
                                                 style="width:230px;float:right;margin-right:50px;">
                                                <p id="cachedExcelP"></p>
                                                <c:forEach items="${batchList}" var="batch">
                                                    <p>
                                                        <font title="${batch.fileName} <fmt:formatDate value="${batch.createTime}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>"
                                                              class="batchFileClass">
                                                                ${batch.fileName} <%-- <fmt:formatDate value="${batch.createTime}" type="both" pattern="MM-dd HH:mm:ss"/> --%>
                                                        </font>
                                                        <a href="javascript:void(0);"
                                                           onclick="deleteExchangeCode('${batch.id}',this)">删除</a>
                                                    </p>
                                                </c:forEach>
                                            </div>
                                        </c:when>
                                        <c:otherwise>
                                            <c:forEach items="${batchList}" var="batch">
                                                <span class="inline">${batch.fileName} (<fmt:formatDate
                                                        value="${batch.createTime}" type="both"
                                                        pattern="yyyy-MM-dd HH:mm:ss"/>)&nbsp;</span>
                                                <br/>
                                            </c:forEach>
                                        </c:otherwise>
                                    </c:choose>
                                </div>
                            </div>

                            <div class="span6 control-group">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <label class="control-label">兑换码模板&nbsp;：</label>
                                        <div class="controls">
                                            <a href="${ctx}/cmcreditgoods/download" class="btn btn-primary">模板下载</a>
                                        </div>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <!-- 兑换码导入 form start -->
                        <%-- <form id="consultant_upload_form" class="form-horizontal valid" name="consultant_upload_form" enctype="multipart/form-data"
                         action="${ctx}/cmcreditgoods/upload" method="post">
                            <input type="file" id="consultant_file" name="consultant_file"
                                 value="" class="required imageValid" required
                                placeholder="请导入名单" title="请选择上传文件"
                                accept="application/vnd.ms-excel" /><input type="hidden"
                                id="code_msg" name="code_msg" value="">
                        </form> --%>
                        <!-- 兑换码导入 form end -->

                </div>

                    <div class="row-fluid" id="timeRange">
                        <div class="span10 control-group">
                            <label class="control-label">有效期：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <div class="span3 input-append date datetime-picker" id="startTimeDiv"
                                             data-date-format="yyyy-mm-dd" date-minView="month">
                                            <input class="span10 startTimeStr" type="text" id="entity.startTimeStr"
                                                   name="entity.startTime" onFocusout="removeErrorLabel()"
                                                   placeholder="开始日期"
                                                   value="<fmt:formatDate value='${entity.startTime}' pattern='yyyy-MM-dd' />"
                                                   required>
                                            <span class="add-on"><i class="icon-remove"></i></span>
                                            <span class="add-on"><i class="icon-calendar"></i></span>
                                        </div>
                                        <div class="span3 input-append date datetime-picker" style="padding-left:30px;" id="endTimeDiv"
                                             data-date-format="yyyy-mm-dd" date-minView="month" >
                                            <input class="span10 endTimeStr" type="text" id="entity.endTimeStr"
                                                   onFocusout="removeErrorLabel()" name="entity.endTime"
                                                   placeholder="结束日期"
                                                   value="<fmt:formatDate value='${entity.endTime}' pattern='yyyy-MM-dd' />"
                                                   required>
                                            <span class="add-on"><i class="icon-remove"></i></span>
                                            <span class="add-on"><i class="icon-calendar"></i></span>
                                        </div>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                        	<fmt:formatDate value='${entity.startTime}' pattern='yyyy-MM-dd'/>
                                        	--
                                        	<fmt:formatDate value='${entity.endTime}' pattern='yyyy-MM-dd'/>
                                        &nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                <!-- 虚拟商品属性 end -->

                <div class="row-fluid">
                    <div class="span6 control-group">
                        <label class="control-label">排序：</label>
                        <div class="controls">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
                                    <input type="text" class="orderNumber required number" id="entity.orderNumber"
                                           name="entity.orderNumber"
                                           value="${entity.orderNumber}" onblur="removeError()"/>
                                    <font color="red"><form:errors path="cmCreditGoodsVo.entity.orderNumber"/></font>
                                </c:when>
                                <c:otherwise>
                                    <span class="inline">${entity.orderNumber}&nbsp;</span>
                                </c:otherwise>
                            </c:choose>

                        </div>
                    </div>
                </div>

                <div class="row-fluid" id="secondKillDiv">
                    <div class="span10 control-group">
                        <c:if test="${action=='create' || action=='edit'}">
                            &nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" id="createSecKillGoods">
                        </c:if>创建为秒杀商品：
                        <div class="controls" id="createSeckillGoodsDiv">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
                                    <div class="span4 input-append date datetime-picker"
                                         data-date-format="yyyy-mm-dd hh:ii:ss" id="startTimeDivSeckill">
                                        <input class="span10 startTimeStrSeckill" type="text"
                                               id="entity_startTimeStrSeckill"
                                               name="entity.seckillStartTime" placeholder="开始日期"
                                               onFocusout="removeErrorLabel()"
                                               value="<fmt:formatDate value='${entity.seckillStartTime}' pattern='yyyy-MM-dd HH:mm:ss' />"
                                               required>
                                        <span class="add-on"><i class="icon-remove"></i></span>
                                        <span class="add-on"><i class="icon-calendar"></i></span>
                                    </div>
                                    <div class="span4 input-append date datetime-picker"
                                         data-date-format="yyyy-mm-dd hh:ii:ss" style="padding-left:30px" ;
                                         id="endTimeDiv">
                                        <input class="span10 endTimeStrSeckill" type="text"
                                               id="entity_endTimeStrSeckill"
                                               name="entity.seckillEndTime" placeholder="结束日期"
                                               onFocusout="removeErrorLabel()"
                                               value="<fmt:formatDate value='${entity.seckillEndTime}' pattern='yyyy-MM-dd HH:mm:ss' />"
                                               required>
                                        <span class="add-on"><i class="icon-remove"></i></span>
                                        <span class="add-on"><i class="icon-calendar"></i></span>
                                    </div>
                                </c:when>
                                <c:otherwise>
                                        <span class="inline">
                                        	<fmt:formatDate value='${entity.seckillStartTime}'
                                                            pattern='yyyy-MM-dd HH:mm:ss'/>
                                        	--
                                        	<fmt:formatDate value='${entity.seckillEndTime}'
                                                            pattern='yyyy-MM-dd HH:mm:ss'/>
                                        &nbsp;</span>
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span10 control-group">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <input type="checkbox" id="isBuyLimit" name="isBuyLimit">不限购
                            </c:when>
                            <c:when test="${action=='edit'}">
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <input type="checkbox" id="isBuyLimit" name="isBuyLimit"
                                       <c:if test="${0 eq entity.isBuyLimit}">checked="checked"</c:if>>
                                不限购
                            </c:when>
                            <c:otherwise>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                是否限购：
                                <c:if test="${0 eq entity.isBuyLimit}">
                                    不限购
                                </c:if>
                                <c:if test="${1 eq entity.isBuyLimit}">
                                    限购
                                </c:if>
                            </c:otherwise>
                        </c:choose>
                    </div>
                </div>

                <%--促销开始--%>
                <c:forEach items="${promotionList}" var="promotion">
                    <div class="row-fluid">
                        <div class="span10 control-group">&nbsp;&nbsp;&nbsp;&nbsp;
                            <c:choose>
                                <c:when test="${action=='create'}">
                                    <input type="checkbox" name="promotions" value="${promotion.name}">
                                </c:when>
                                <c:when test="${action=='edit'}">
                                    <c:if test="${!empty promotions}">
                                        <c:forEach items="${promotions}" var="hitPromotion">
                                            <c:if test="${hitPromotion.promotionId eq promotion.id}">
                                                <input type="checkbox" name="promotions" value="${promotion.name}"
                                                       checked="checked">
                                            </c:if>
                                        </c:forEach>
                                    </c:if>
                                    <c:if test="${empty promotions}">
                                        <input type="checkbox" name="promotions" value="${promotion.name}">
                                    </c:if>
                                </c:when>
                            </c:choose>

                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
                                    创建为${promotion.description}：
                                </c:when>
                                <c:otherwise>
                                    <c:forEach items="${promotions}" var="hitPromotion">
                                        <c:if test="${hitPromotion.promotionId eq promotion.id}">
                                            创建为${promotion.description}：
                                        </c:if>
                                    </c:forEach>
                                </c:otherwise>
                            </c:choose>

                        </div>
                    </div>

                    <c:forEach items="${promotionConfigList}" var="promotionConfig">
                        <c:if test="${promotion.id eq promotionConfig.promotionId}">
                            <div class="row-fluid">
                                <div class="span10 control-group">
                                    <c:choose>
                                        <c:when test="${action=='create'}">
                                            <c:if test="${'dateTime' eq promotionConfig.configType}">
                                                <div class="span4 input-append date datetime-picker"
                                                     data-date-format="yyyy-mm-dd" style="padding-left:25px;"
                                                     id="${promotionConfig.configName}">
                                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                                    <input class="span10 startTimeStrSeckill" type="text"
                                                           id="${promotionConfig.configName}"
                                                           name="${promotion.name}_${promotionConfig.configName}"
                                                           placeholder="开始日期"
                                                           onFocusout="removeErrorLabel()">
                                                    <span class="add-on"><i class="icon-remove"></i></span>
                                                    <span class="add-on"><i class="icon-calendar"></i></span>
                                                </div>
                                            </c:if>
                                        </c:when>
                                        <c:when test="${action=='edit'}">

                                            <c:if test="${!empty promotions}">
                                                <c:forEach items="${promotions}" var="hitPromotion">
                                                    <c:if test="${'dateTime' eq promotionConfig.configType}">
                                                        <c:if test="${hitPromotion.configKey eq promotionConfig.configName}">
                                                            <div class="span4 input-append date datetime-picker"
                                                                 data-date-format="yyyy-mm-dd"
                                                                 style="padding-left:25px;"
                                                                 id="${promotionConfig.configName}">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;
                                                                <input class="span10 startTimeStrSeckill" type="text"
                                                                       id="${promotionConfig.configName}"
                                                                       name="${promotion.name}_${promotionConfig.configName}"
                                                                       placeholder="开始日期"
                                                                       onFocusout="removeErrorLabel()"
                                                                       value="${hitPromotion.configValue}">
                                                                <span class="add-on"><i class="icon-remove"></i></span>
                                                                <span class="add-on"><i
                                                                        class="icon-calendar"></i></span>
                                                            </div>
                                                        </c:if>
                                                    </c:if>
                                                </c:forEach>
                                            </c:if>

                                            <c:if test="${empty promotions}">
                                                <div class="span4 input-append date datetime-picker"
                                                     data-date-format="yyyy-mm-dd" style="padding-left:25px;"
                                                     id="${promotionConfig.configName}">
                                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                                    <input class="span10 startTimeStrSeckill" type="text"
                                                           id="${promotionConfig.configName}"
                                                           name="${promotion.name}_${promotionConfig.configName}"
                                                           placeholder="开始日期"
                                                           onFocusout="removeErrorLabel()">
                                                    <span class="add-on"><i class="icon-remove"></i></span>
                                                    <span class="add-on"><i class="icon-calendar"></i></span>
                                                </div>
                                            </c:if>

                                        </c:when>
                                        <c:otherwise>
                                        <span class="inline" style="padding-left:25px;">

                                            <c:forEach items="${promotions}" var="hitPromotion">
                                                <c:if test="${hitPromotion.configKey eq promotionConfig.configName}">
                                                    ${promotionConfig.description}：${hitPromotion.configValue} <br>
                                                </c:if>
                                            </c:forEach>

                                        </span>
                                        </c:otherwise>
                                    </c:choose>
                                </div>
                            </div>
                        </c:if>
                    </c:forEach>
                </c:forEach>

                <%--促销结束--%>

                <div class="house365Border"
                     style="height:auto; margin-left: 20px; margin-right: 20px; margin-bottom: 20px;">
                    <!-- house365Border2 start-->
                    <div class="sectionTitle" style="background-color:#F9F9F9; color:#0E0E0F">
                        <h5>商品介绍</h5>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">商品描述：</label>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
										<textarea class="description required"
                                                  style="margin: 0px; height: 126px; width: 616px;"
                                                  id="entity.description"
                                                  name="entity.description"
                                                  onblur="removeError()">${entity.description}</textarea>
                                </c:when>
                                <c:otherwise>
                                    <span style="line-height: 40px;">${entity.description}&nbsp;</span>
                                </c:otherwise>
                            </c:choose>

                        </div>
                    </div>

                    <div class="row-fluid" id="useRange">
                        <div class="span6 control-group">
                            <label class="control-label">使用范围：</label>
                        </div>
                        <div class="controls">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
											<textarea class="usableRange required"
                                                      style="margin: 0px; height: 126px; width: 616px;"
                                                      id="entity.usableRange"
                                                      name="entity.usableRange"
                                                      onblur="removeError()">${entity.usableRange}</textarea>
                                </c:when>
                                <c:otherwise>
                                    <span style="line-height: 40px;">${entity.usableRange}&nbsp;</span>
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">兑换流程：</label>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
										<textarea class="exchangeProcess required"
                                                  style="margin: 0px; height: 126px; width: 616px;"
                                                  id="entity.exchangeProcess"
                                                  name="entity.exchangeProcess"
                                                  onblur="removeError()">${entity.exchangeProcess}</textarea>
                                </c:when>
                                <c:otherwise>
                                    <span style="line-height: 40px;">${entity.exchangeProcess}&nbsp;</span>
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">注意事项：</label>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
										<textarea class="announcement required"
                                                  style="margin: 0px; height: 126px; width: 616px;"
                                                  id="entity.announcement"
                                                  name="entity.announcement"
                                                  onblur="removeError()">${entity.announcement}</textarea>
                                </c:when>
                                <c:otherwise>
                                    <span style="line-height: 40px;">${entity.announcement}&nbsp;</span>
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">地址链接：</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        默认
                                    </c:when>
                                    <%--  <c:when test="${action=='edit'}">
                                     <input type="hidden" id="entity.adLink" name="entity.adLink" value="http://m.house365.com/H5/Shopingmall/index.php?s=/Home/Goods/details/id/${entity.id}/from/index.html">

                                     </c:when> --%>
                                    <c:otherwise>
                            		<span style="line-height: 40px;">
                                            ${entity.adLink}</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                </div><!-- house365Border2 end-->


                <%-- <div id="singleDiv2">
                <div class="row-fluid">
                    <div class="span10 control-group">
                        <label class="control-label">使用有效期：</label>
                        <div class="controls">
                            <c:choose>
                                <c:when test="${action=='create' || action=='edit'}">
                                   <div class="span3 input-append date datetime-picker" id="startTimeDiv" data-date-format="yyyy-mm-dd" date-minView="month" >
                                        <input class="span10 startTimeStr" type="text" id="entity.startTimeStr" name="entity.startTime" readonly placeholder="开始日期" value="<fmt:formatDate value='${entity.startTime}' pattern='yyyy-MM-dd' />" required >
                                        <span class="add-on"><i class="icon-remove"></i></span>
                                        <span class="add-on"><i class="icon-calendar"></i></span>
                                    </div>
                                    <div class="span3 input-append date datetime-picker" style="padding-left:30px; id="endTimeDiv" data-date-format="yyyy-mm-dd" date-minView="month" >
                                        <input class="span10 endTimeStr" type="text" id="entity.endTimeStr" name="entity.endTime" readonly placeholder="结束日期" value="<fmt:formatDate value='${entity.endTime}' pattern='yyyy-MM-dd' />"  required >
                                        <span class="add-on"><i class="icon-remove"></i></span>
                                        <span class="add-on"><i class="icon-calendar"></i></span>
                                    </div>
                                </c:when>
                                <c:otherwise>
                                    <span class="inline">
                                        <fmt:formatDate value='${entity.startTime}' pattern='yyyy-MM-dd' />
                                        --
                                        <fmt:formatDate value='${entity.endTime}' pattern='yyyy-MM-dd' />
                                    &nbsp;</span>
                                </c:otherwise>
                            </c:choose>

                        </div>
                    </div>
                </div>
                </div> --%>

            </div><!-- house365Border1 end-->
        </div>
    </div>
    </div>
</form>
<script type="text/javascript" src="${static_common}/script/jquery-validation-1.11.1/dist/jquery.validate.min.js"></script>
<script type="text/javascript" src="${static_common}/ckeditor/ckeditor.js"></script>

<script type="text/javascript">
    $(function () {

        $(".batchFileClass").each(function () {
            subStringForTitle(this);
        });

        //离开的判断
        $(".leaveEditClass").click(function () {
            <c:choose>
            <c:when test="${action=='create' || action=='edit' }">
            var bool = window.confirm("确认离开编辑页面?");
            if (bool) {
                window.location = $(this).attr("ahref");
            } else {
                return;
            }
            </c:when>
            <c:otherwise>
            window.location = $(this).attr("ahref");
            </c:otherwise>
            </c:choose>
        });

        //秒杀状态更改
        if ($("#entityIsSeckill").val() == "1") {
            $("#createSecKillGoods").attr("checked", "checked");
            $("#createSeckillGoodsDiv").show();
        } else {
            $("#createSeckillGoodsDiv").hide();
            $("#createSecKillGoods").removeAttr("checked");
        }

        //更改创建秒杀商品状态
        $("#createSecKillGoods").change(function (target) {
            if (target.target.checked) {
                $("#createSeckillGoodsDiv").show();
                $("#entityIsSeckill").val("1");
            } else {
                $("#createSeckillGoodsDiv").hide();
                $("#entityIsSeckill").val("0");
            }
        });

    });


    //保存
    function submitBulletin(btn) {
        var urlLink = document.getElementById("entity.urlLink").value;
        var content = document.getElementById("entity.content").value;
        if (urlLink == '' && content == '') {
            House365Util.createModal("新增", "至少填写一个!", function () {
            });
            return;
        }
        else {
            $('#input_form').submit();
        }
    }

    function ifallSiteAccess() {
        if (document.getElementById("ifallSitesAccess").checked) {
            document.getElementById("entity.allSitesAccess").value = 1;
        }
        else {
            document.getElementById("entity.allSitesAccess").value = 0;
        }
    }
    var fileUploadCount = 1;

    $(function () {
        <c:if test="${action=='create'}">
        $("#singleDiv3").hide();
        $("#entityStock").val(0);
        </c:if>
        <c:if test="${'0' eq entity.goodsType}">
        $("#singleDiv").hide();
        $("#singleDiv2").hide();
        $("#singleDiv3").show();
        $("#useRange").hide();
        </c:if>
        <c:if test="${'1' eq entity.goodsType}">
        $("#singleDiv").show();
        $("#singleDiv2").show();
        $("#useRange").show();
        </c:if>
        <c:if test="${'2' eq entity.goodsType}">
        $("#singleDiv").hide();
        $("#singleDiv2").hide();
        $("#singleDiv3").show();
        $("#useRange").hide();
        $("#thirdParty").show();
        </c:if>
        //操作切换selected
        $(".goodsType").change(function () {
            var $this = $(this);
            var val = $this.val();
            if ('1'==val) {
                //虚拟商品
                $("#replenishmentDiv").hide();
                $("#singleDiv").show();
                $("#timeRange").show();
                $("#singleDiv2").show();
                $("#singleDiv3").hide();
                $(".startTimeStr").attr("disabled", false);
                $(".endTimeStr").attr("disabled", false);
                $(".startTimeStr").attr("required");
                $(".endTimeStr").attr("required");
                $("#secondKillDiv").show();
                $("#useRange").show();
                $("#thirdParty").hide();
            } else if("0"==val){
                //实物商品
                $("#replenishmentDiv").show();
                $("#singleDiv").hide();
                $("#singleDiv2").hide();
                $("#singleDiv3").show();
                $(".startTimeStr").attr("disabled", true);
                $(".endTimeStr").attr("disabled", true);
                $(".startTimeStr").removeAttr("required");
                $(".endTimeStr").removeAttr("required");
                $("#secondKillDiv").show();
                $("#useRange").hide();
                $("#thirdParty").hide();
                $("#timeRange").hide();
            } else if("2"==val){
                //第三方
                $("#replenishmentDiv").show();
                $("#singleDiv").hide();
                $("#timeRange").show();
                $("#singleDiv2").hide();
                $("#singleDiv3").show();
                $(".startTimeStr").attr("disabled", false);
                $(".endTimeStr").attr("disabled", false);
                $(".startTimeStr").attr("required");
                $(".endTimeStr").attr("required");
                $("#useRange").hide();
                $("#secondKillDiv").hide();
                $("#thirdParty").show();
            }
        });

        //触发文件上传事件
        onChangeFile();

        CKEDITOR.replaceAll();


    });

    $(".startTimeStr").change(function () {
        $(".startTimeStr2").val($(".startTimeStr").val());
    });
    $(".endTimeStr").change(function () {
        $(".endTimeStr2").val($(".endTimeStr").val());
    });


    $(".startTimeStrSeckill").change(function () {
        $(".startTimeStr2").val($(".startTimeStrSeckill").val());
    });
    $(".endTimeStrSeckill").change(function () {
        $(".endTimeStr2").val($(".endTimeStrSeckill").val());
    });

    function CKupdate() {
        for (instance in CKEDITOR.instances)
            CKEDITOR.instances[instance].updateElement();
    }

    function submitForm(value) {
        CKupdate();
        //设置图片路径
        var isPictureAll = true;
        if ($("#indexPicture_list_container img")) {
            var indexPicture = $("#indexPicture_list_container img").attr("src");
            $(".indexPictureHidden").val(indexPicture);
            if (!indexPicture) {
                isPictureAll = false;
            }
        }
        if ($("#detailPicture_list_container img")) {
            var detailPicture = $("#detailPicture_list_container img").attr("src");
            $(".detailPictureHidden").val(detailPicture);
            if (!detailPicture) {
                isPictureAll = false;
            }
        }
        if ($("#listPicture_list_container img")) {
            var listPicture = $("#listPicture_list_container img").attr("src");
            $(".listPictureHidden").val(listPicture);
            if (!listPicture) {
                isPictureAll = false;
            }
        }
        if ($("#smallListPicture_list_container img")) {
            var smallListPicture = $("#smallListPicture_list_container img").attr("src");
            $(".smallListPictureHidden").val(smallListPicture);
            if (!smallListPicture) {
                isPictureAll = false;
            }
        }
        if (!isPictureAll) {
            alert("请完善4张图片!");
            return;
        }
        $("#sign").val(value.id);

        var startDateStr = $('#entity_startTimeStrSeckill').val();
        var endDateStr = $('#entity_endTimeStrSeckill').val();

        if (startDateStr != '' && startDateStr != null && startDateStr != undefined) {
            if (endDateStr != '' && endDateStr != null && endDateStr != undefined) {
                var startDate = eval('new Date(' + startDateStr.replace(/\d+(?=-[^-]+$)/,
                                function (a) {
                                    return parseInt(a, 10) - 1;
                                }).match(/\d+/g) + ')');
                var endDate = eval('new Date(' + endDateStr.replace(/\d+(?=-[^-]+$)/,
                                function (a) {
                                    return parseInt(a, 10) - 1;
                                }).match(/\d+/g) + ')');

                if (startDate > endDate) {
                    alert("秒杀开始时间不能大于截止时间");
                    return;
                } else if (parseInt(Math.abs(endDate - startDate) / 1000 / 60 / 60) >= 24) {
                    alert("秒杀时间段不能超过一天")
                    return;
                }

            }
        }

        var gty = $(".goodsType").val();
        if('2'==gty){
            if(!$("#thirdLink").val()){
                alert("第三方领取商品链接不能为空");
                return;
            }
        }

        var $inputForm = $("#input_form");
        var validSucc = $inputForm.valid({});

        if (validSucc) {
            //禁用提交按钮
            $("#save").attr("disabled", "disabled");
            $("#save").html("提交中...");
            $("#up").attr("disabled", "disabled");
            $("#up").html("提交中...");
            // 提交表单
            $.ajax({
                url: $inputForm.attr("action"),
                data: $inputForm.serialize(),
                type: "POST",
                dataType: "json",
                success: function (data) {
                    var obj = eval(data);
                    if (obj.goodsType == "0" || obj.goodsType == "2") {
                        window.location.href = "${ctx}/cmcreditgoods/" + obj.id;
                    } else if (obj.goodsType == "1") {
                        if (obj.respCode == "0") {
                            House365Util.createModal('修改',
                                    '修改成功!',
                                    function () {
                                        window.location.href = "${ctx}/cmcreditgoods/" + obj.id;
                                    });
                        } else {
                            // 提示信息
                            House365Util.createRemoteModal("添加结果",
                                    "${ctx}/cmcreditgoods/showMessageSection",
                                    data, function () {
                                        window.location.href = "${ctx}/cmcreditgoods/" + obj.id;
                                    }, "", "btn-info", "关闭",
                                    "btn-info btn-jxtj");
                        }

                    } else if (obj.errorMessage == "noUploadFile") {
                        House365Util.createModal('文件上传',
                                '未上传兑换码!',
                                function () {
                                    window.location.reload();
                                });

                    } else if (obj.errorMessage != "") {
                        House365Util.createModal('保存失败',
                                obj.errorMessage,
                                function () {
//                                    window.location.reload();
                                });

                    }
                    //启用提交按钮
                    $("#save").removeAttr("disabled");
                    $("#save").html("保存");
                    $("#up").removeAttr("disabled");
                    $("#up").html("上架");

                },
                error: function () {
                    //启用提交按钮
                    $("#save").removeAttr("disabled");
                    $("#save").html("保存");
                    $("#up").removeAttr("disabled");
                    $("#up").html("上架");
                },
                complete: function () {
                    //启用提交按钮
                    $("#save").removeAttr("disabled");
                    $("#save").html("保存");
                    $("#up").removeAttr("disabled");
                    $("#up").html("上架");
                    // 弹窗点击列表直接跳转走，点击继续添加则重置表单
                    /*$(".goodsName").val("");
                     $(".goodsId").val("");
                     $(".creditsNeeded").val("");
                     $(".price").val("");
                     $(".stock").val("");
                     $(".replenishment").val("");
                     $(".startTimeStr").val("");
                     $(".endTimeStr").val("");
                     $(".startTimeStr2").val("");
                     $(".endTimeStr2").val("");
                     $(".orderNumber").val("");
                     $(".description").val("");
                     $(".usableRange").val("");
                     $(".exchangeProcess").val("");
                     $(".announcement").val("");*/
                }
            });
        }
        //隐藏所有error提示信息
        $(".error").siblings("label").hide();
    }

    var deleteExchangeCode = function (id, target) {
        // 提示信息

        House365Util.createModal("提示", "确定删除？", function () {
            $.ajax({
                url: "${ctx}/cmcreditgoods/deleteExchangeCode/" + id,
                type: "GET",
                success: function (data) {
                    if (data == "10000") {
                        $(target).parent().remove();
                    }
                }
            });
        });


    }

    $(".btn-jxtj").on("click", function () {

    });

    function removeError() {
        $(".error").siblings("label").hide();
    }

    var shelves = function (ud, selectedId) {
        $.ajax({
            url: '${ctx}/cmcreditgoods/shelves/' + ud + '/' + selectedId,
            type: "GET",
            success: function (data) {
                if (data == "up") {
                    House365Util.createModal("上架", "确认上架?", function () {
                        window.location.reload();
                    });
                }
                if (data == "down") {
                    House365Util.createModal("下架", "确认下架?", function () {
                        window.location.reload();
                    });
                }

            }
        });
    }

    //修改货物
    function editGoods() {
        if ('${entity.status}' == 0) {
            House365Util.createModal("商品处于上架状态", "<strong>请下架商品后修改!</strong>", function () {
            });
            return;
        } else {
            window.location = "${ctx}/cmcreditgoods/${entity.id}?action=edit";
        }
    }


    //
    function onChangeFile() {

        //上传导入excel
        $("#consultant_file").on("change", function () {
            fileUploadCount++;
            var $uploadForm = $("#consultant_upload_form");
            //$("#consultant_t").val(new Date());
            var arr = $(this).val().split('\\');
            var str = arr[arr.length - 1];
            //var validValue = $uploadForm.valid();
            //if (validValue) {
            $.ajaxFileUpload({
                // 文件上传服务器地址
                //url : $uploadForm.attr("action"),
                url: "${ctx}/cmcreditgoods/upload?uniquePageKey=${uniquePageKey}",
                // 文件上传服务器地址
                fileElementId: "consultant_file",
                // 表单数据
                data: $uploadForm.serialize(),
                // 成功回调
                success: function (data, status) {
                },
                error: function (data, status, e) {
                    // 失败后操作
                    alert("上传失败，请联系管理员！");
                    $("#code_msg").html("");
                    $("#code_msg").val(0);
                    $("#code_msg").hidden();
                },
                complete: function (request) {
                    House365Util.createModal('文件上传',
                            '上传成功，文件名：' + str,
                            function () {
                            });
                    $("#code_msg").html("已上传");
                    $("#code_msg").val(1);
                    $("#consultant_file").val("");
                    $("#cachedExcelP").html('<font style="color:red" title="暂存至服务器，提交后保存！' + str + '" class="">' + str + '</font>');
                    subStringForTitle($("#cachedExcelP font"));
                }
            });
            //}

            $("#consultant_file").replaceWith('<input type="file" id="consultant_file" name="consultant_file" value=""\
   						class="imageValid" placeholder="请导入名单" title="请选择上传文件"\
   						accept="application/vnd.ms-excel" style="display: none" nosense="' + fileUploadCount + '" />');
            onChangeFile();
        });

    }
    //截取字符串显示
    function subStringForTitle(target) {
        var fileName = $(target).html().replace(/(^\s*)|(\s*$)/g, "");
        if (fileName.length > 15) {
            fileName = fileName.substring(0, 12) + "...";
        }
        $(target).html(fileName);
    }

    function removeErrorLabel() {
        $("label.error").remove();
    }

</script>
</body>

</html>
