package com.house365.web.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.house365.web.controller.InterfaceController;

public class StringFileUtils {
    
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(StringFileUtils.class);
    
    public static String[] forbiddenWords={};
    public static String forbiddenText;
    //载入被禁词汇
    static{
        String path = StringFileUtils.class.getResource("/").getPath();
        
        if(path.contains(":")){
            path = "E:/";//path.substring(1);
        }
        Path wiki_path = Paths.get(path+"properties/", "prohibitivewords.txt");
        LOGGER.debug("path----:"+path);
        LOGGER.debug("full_path----:"+wiki_path);
        try {
          byte[] wikiArray = Files.readAllBytes(wiki_path);
          forbiddenText = new String(wikiArray, "utf-8");
          forbiddenWords = forbiddenText.split(",");
        } catch (IOException e) {
            e.printStackTrace();
        }
        
    }
    
    
    
    /**
     * 
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年11月11日]
     * @param path
     * @param encoding
     * @return
     * @throws IOException
     * @since [产品/模块版本](可选)
     */
    public static String readFile(String path, String encoding) throws IOException {
            byte[] encoded = Files.readAllBytes(Paths.get(path));
            return new String(encoded, encoding);
    }
    
    /**
     * 判断文本是否已含有被禁词汇
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年11月14日]
     * @param text
     * @return
     * @since [产品/模块版本](可选)
     */
    public static boolean hasForbiddenWord(String text){
        
        for(String tmpStr : forbiddenWords){
            if(text.contains(tmpStr)){
                return true;
            }
        }
        return false;
    }
    
    public static void main(String[] args){
        String path = StringFileUtils.class.getClassLoader().getResource(".").getPath();
      
        if(path.contains(":")){
            path = path.substring(1);
            System.out.println(path);
        }
        Path wiki_path = Paths.get(path+"properties/", "prohibitivewords.txt");
        try {
          byte[] wikiArray = Files.readAllBytes(wiki_path);
          String wikiString = new String(wikiArray, "utf-8");
          forbiddenText = wikiString;
          String[] forbiddenWords = wikiString.split(",");
          String aaa = "asdfasdfasdf,asdfasdfjkasdfjkaj,asdfjaskdlsdkfjlasdflzbs.com.cn";
          for(String tmpStr : forbiddenWords){
              if(aaa.contains(tmpStr)){
                  System.out.println("禁语言");
                  break;
              }
          }
          
          
          System.out.println(wikiString);
          
          String phone = "13082511415";
           String strr = phone.subSequence(0, 3)+"****"+phone.subSequence(7, 11);
           System.out.println(strr);
          
        } catch (IOException e) {
          System.out.println(e);
        }
        
        
    }
}
