package com.house365.web.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 日期时间工具类
 * 
 * @author nizhengjia
 * @date 
 * @version 1.0
 */
public class DateUtils {
	
	 	/**
	 	 * 功能描述: <br>
	     * 根据指定格式对当前日期进行格式化
	     * (传入：String，返回：String)
	     * 
	     * @param Date date 传入日期类型日期
	     * @param String format 需要转化的格式
	     * @return String 转换后的字符串格式日期
	     */
	    public static String parseDate(Date date, String format) {
	        SimpleDateFormat dateformat = new SimpleDateFormat(format);
	        return dateformat.format(date);
	    }
	    
	    /**
	 	 * 功能描述: <br>
	     * 根据指定格式对当前日期进行格式化
	     * (传入：String，返回：String)
	     * 
	     * @param Date date 传入日期类型日期
	     * @param String format 需要转化的格式
	     * @return String 转换后的字符串格式日期
	     */
	    public static String dateToStr(Date date) {
	        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
	        return dateformat.format(date);
	    }
	    
	    /**
	     * 功能描述: <br>
	     * 根据指定格式对当前日期进行格式化
	     * (传入：String，返回：Date)
	     * 
	     * @param String 传入字符串类型日期
	     * @param format 需要转化的格式
	     * @return Date 转换后的日期类型日期 
	     */
	    public static Date parseDate(String datestr, String dateFormate) {
	        SimpleDateFormat df = new SimpleDateFormat(dateFormate);
	        Date date = null;
	        try {
	        	date = df.parse(datestr);
			} catch (java.text.ParseException e) {
				e.printStackTrace();
			}
	        return date;
	    }
	    
	    /**
	     * 功能描述: <br>
	     * 根据指定格式对当前日期进行格式化
	     * (传入：String，返回：String)
	     * 
	     * @param String 传入字符串类型日期
	     *               需要转化的格式为yyyy-MM-dd
	     * @return String 转换后的日期类型日期 
	     */
	    public static String parseDate(String datestr) {
	        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
	        String str = null;
	        Date date = null;
	        try {
	        	date = df.parse(datestr);
	        	str = df.format(date);
			} catch (java.text.ParseException e) {
				e.printStackTrace();
			}
	        return str;
	    }
	 
	    /**
	     * 功能描述: <br>
	     * 获取指定日期的月份第一天的时间
	     * (传入：Date，返回：String)
	     *
	     * @param date 日期类型
	     * @return 如2014-06-01 00:00:00 字符串
	     */
	    public static String getMonthBegin(Date date) {
	        return parseDate(date,"yyyy-MM") + "-01 00:00:00";
	    }
	    
	    /**
	     * 功能描述: <br>
	     * 获取指定日期的月份最后一天的时间
	     *(传入：Date，返回：String)
	     *
	     * @param targetDate 日期类型
	     * @return 如2014-06-30 23:59:59 字符串
	     */
	    public static String getMonthEnd(Date targetDate) {
	        Date date = parseDate(getMonthBegin(targetDate),"yyyy-MM-dd");
	        Calendar calendar = Calendar.getInstance();
	        calendar.setTime(date);
	        calendar.add(Calendar.MONTH,1);
	        calendar.add(Calendar.DAY_OF_YEAR, -1);
	        String strResult = "";
	        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
	        strResult = simpleDateFormat.format(calendar.getTime());
	        simpleDateFormat = null;
	        calendar = null;
	        return strResult + " 23:59:59";
	    }
	    
	    /**
	     * 功能描述: <br>
	     * 获取指定日期的月份最后一天的时间
	     *(传入：Date,int ，返回：String)
	     *
	     * @param targetDate 日期类型
	     * @int y 指定int类型的月份(1:前一个月，2：前二个月，3：前三个月，4：前四个月，5：前五个月)
	     * @return 如2014-06-30 23:59:59 字符串
	     */
	    public static String getMonthsAgo(Date dt,int y){
	    	Date nextDate = null;
	    	Calendar calendar = Calendar.getInstance();
	    	calendar.setTime(new Date());
	    	calendar.add(Calendar.MONTH, -y);
	    	nextDate = calendar.getTime();
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
	    	String dateTime = sdf.format(nextDate); 
	    	return dateTime;
	    	
	    }
	    
	    /**
	     * 功能描述: <br>
	     * date转毫秒
	     */
	    public static long millionSeconds (Date dt){
	    	long hm =  dt.getTime();
	    	return hm;
	    }
	    
	    

	    /**
	     * 获取一个月的最后一天
	     * 
	     * @param year
	     *            yyyy
	     * @param month
	     *            MM
	     * @return
	     */
	    public static String getLastDayOfMonth(int year, int month) {
	        Calendar cal = Calendar.getInstance();
	        cal.set(Calendar.YEAR, year);
	        cal.set(Calendar.MONTH, month);
	        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DATE));
	        return new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
	    }

	    /**
	     * 获取一个月的第一天
	     * 
	     * @param year
	     *            yyyy
	     * @param month
	     *            MM
	     * @return
	     */
	    public static String getFirstDayOfMonth(int year, int month) {
	        Calendar cal = Calendar.getInstance();
	        cal.set(Calendar.YEAR, year);
	        cal.set(Calendar.MONTH, month);
	        cal.set(Calendar.DAY_OF_MONTH, cal.getMinimum(Calendar.DATE));
	        return new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
	    }

	    /**
	     * 获取某年中某一个月的天数
	     * 
	     * @param dyear
	     *            yyyy
	     * @param dmouth
	     *            MM
	     * @return
	     */
	    public static int calDayByYearAndMonth(String dyear, String dmouth) {
	        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM");
	        Calendar rightNow = Calendar.getInstance();
	        try {
	            rightNow.setTime(simpleDate.parse(dyear + "/" + dmouth));
	        } catch (ParseException e) {
	            e.printStackTrace();
	        }
	        return rightNow.getActualMaximum(Calendar.DAY_OF_MONTH);// 根据年月 获取月份天数
	    }

	    /**
	     * 计算两个日期之间相差的天数
	     * 
	     * @param smdate
	     *            较小的时间
	     * @param bdate
	     *            较大的时间
	     * @return 相差天数
	     * @throws ParseException
	     */
	    public static int daysBetween(Date smdate, Date bdate)
	            throws ParseException {
	        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	        /*smdate = sdf.parse(sdf.format(smdate));
	        bdate = sdf.parse(sdf.format(bdate));*/
	        //System.out.println("smdate:"+sdf.format(smdate)+"-----bdate:"+sdf.format(bdate));
	        Calendar cal = Calendar.getInstance();
	        cal.setTime(smdate);
	        long time1 = cal.getTimeInMillis();
	        cal.setTime(bdate);
	        long time2 = cal.getTimeInMillis();
	        long between_days = (time2 - time1) / (1000 * 3600 * 24);

	        return Integer.parseInt(String.valueOf(between_days));
	    }

	    /**
	     * 字符串的日期格式的计算
	     * 
	     * @param smdate
	     *            yyyy-MM-dd
	     * @param bdate
	     *            yyyy-MM-dd
	     * @return
	     * @throws ParseException
	     */
	    public static int daysBetween(String smdate, String bdate)
	            throws ParseException {
	        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	        Calendar cal = Calendar.getInstance();
	        cal.setTime(sdf.parse(smdate));
	        long time1 = cal.getTimeInMillis();
	        cal.setTime(sdf.parse(bdate));
	        long time2 = cal.getTimeInMillis();
	        long between_days = (time2 - time1) / (1000 * 3600 * 24);

	        return Integer.parseInt(String.valueOf(between_days));
	    }

	    /**
	     * 获取当前日期的季度 1. 
	     * 第一季度：1月1号，3月31号 2. 
	     * 第二季度：4月1号，6月30号 3. 
	     * 第三季度：7月1号，9月30号 4.
	     * 第四季度：10月1号，12月31号
	     */
	    public static int getCurrentQuarter() throws ParseException {
	        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	        String nowDate = sdf.format(new Date());
	        Calendar cal = Calendar.getInstance();
	        int currentYear = cal.get(Calendar.YEAR);
	        if (daysBetween(currentYear + "-4-1", nowDate) < 0) {
	            return 1;
	        } else if (daysBetween(currentYear + "-7-1", nowDate) < 0) {
	            return 2;
	        } else if (daysBetween(currentYear + "-10-1", nowDate) < 0) {
	            return 3;
	        } else {
	            return 4;
	        }
	    }

	    /**
	     * 获取当前时间在当前季度中所属天数
	     * 
	     * @return
	     * @throws ParseException
	     */
	    public static int getCurrentDaysCountInCurrentQuarter() throws ParseException{
	        int i = getCurrentQuarter();
	        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
	        String nowDate = sdf.format(new Date());
	        Calendar cal = Calendar.getInstance();
	        int currentYear = cal.get(Calendar.YEAR);
	        switch(i){
	            case 1:
	                return daysBetween(currentYear + "-1-1", nowDate)+1;
	            case 2:
	                return daysBetween(currentYear + "-4-1", nowDate)+1;
	            case 3:
	                return daysBetween(currentYear + "-7-1", nowDate);
	            case 4:
	                return daysBetween(currentYear + "-10-1", nowDate);
	            default:
	                return 0;
	        }
	    }
	    
	    /**
	     * 获取日期的季度
	     */
	    public static int getQuarterByDateString(String dateStr) {
	        return 1;
	    }
	    
	    
	    public static String dateToString(Date date) throws Exception{
	        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	        
	        return sdf.format(date);
	    }
	    
	    //获取7天前，14天前，30天前日期
	    public static  Date getTimeByType(int type) throws ParseException{
	        Calendar   c   =   Calendar.getInstance();
	        c.add(Calendar.DAY_OF_MONTH,-type);//关键是这个7天前....
	        SimpleDateFormat   sdf   =   new   SimpleDateFormat( "yyyy-MM-dd");
	        String ss = sdf.format(c.getTime());
	        Date date = sdf.parse(ss);
	        return date ;
	    }
	    
	    //获取时间段内所有时间
	    public static List<String> getDateStringList(Date beginDate,Date endTime) throws ParseException{

            Calendar cal = Calendar.getInstance();  
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");  
            List<Date> lDate = findDates(beginDate, endTime);  
            List<String> list = new ArrayList<String>();
            for (int i=0;i<lDate.size()-1;i++ ) {  
                list.add(sdf.format(lDate.get(i)).toString());
            }  
	        return list;
	        
	    }
	    public static List<Date> findDates(Date dBegin, Date dEnd) {  
	        List lDate = new ArrayList();  
	        lDate.add(dBegin);  
	        Calendar calBegin = Calendar.getInstance();  
	        // 使用给定的 Date 设置此 Calendar 的时间    
	        calBegin.setTime(dBegin);  
	        Calendar calEnd = Calendar.getInstance();  
	        // 使用给定的 Date 设置此 Calendar 的时间    
	        calEnd.setTime(dEnd);  
	        // 测试此日期是否在指定日期之后    
	        while (dEnd.after(calBegin.getTime())) {  
	            // 根据日历的规则，为给定的日历字段添加或减去指定的时间量    
	            calBegin.add(Calendar.DAY_OF_MONTH, 1);  
	            lDate.add(calBegin.getTime());  
	        }  
	        return lDate;  
	    }  
}
