package com.house365.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.house365.rest.context.CmConstant;
import com.house365.rest.context.ServiceConstant;

/**
 * 限制直接输入链接地址访问系统需校验用户名和密码
 *
 * @author zhaodeshan
 * @version [版本号, 2015年5月8日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class AuthenticationInterceptor extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
                             Object handler) throws Exception {
        HttpSession session = request.getSession();
        String username = (String) session.getAttribute(CmConstant.USER_NAME);
        //String password = (String) session.getAttribute(CmConstant.USER_PASSWORD);
        Object cityObj = request.getSession().getAttribute(ServiceConstant.CITY_ID);
        String requestURI = request.getRequestURI();
        if (requestURI.contains("ranks") || requestURI.contains("secure") || requestURI.contains("api") || requestURI.contains("rest/") || requestURI.contains("php/login") || requestURI.contains("image/addSection")) {
            return true;
        }
        if (Strings.isNullOrEmpty(username) || null == cityObj) {
            response.sendError(403, "禁止访问");
            return false;
        }
        return true;
    }
}
