/**
 * Description: KlfCity控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-10 上午 10:47:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.entity.KlfCityEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.KlfCityVo;
import com.house365.rest.context.CmConstant;
import com.house365.web.cached.RedisUtilsInterface;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.KlfCityListRequest;
import com.house365.ws.beans.request.KlfCityRequest;
import com.house365.ws.beans.response.KlfCityListResponse;
import com.house365.ws.beans.response.KlfCityResponse;
import com.house365.ws.interfaces.server.IKlfCity;
import com.mysql.jdbc.log.LogUtils;

/**
 * KlfCity控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/klfcity")
public class KlfCityController extends BaseController {

	/**
	 * 自动注入KlfCityWS实现
	 */
	@Autowired
	private IKlfCity klfCity;
    @Autowired
    RedisUtilsInterface redisUtils;
	
	/**
	 * 去新增KlfCity
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
	    redisUtils.popIntegerFromRedisList(CmConstant.SECKILL_LEFT_STOCK_LIST+"30");
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增KlfCity
	 * 
	 * @param klfCity KlfCity页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createKlfCity(@Valid KlfCityVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		KlfCityEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                KlfCityRequest request = new KlfCityRequest();
                request.setEntity(entity);
                //如果城市简称已经存在
                KlfCityListRequest requestList = new KlfCityListRequest();
                Map<String, Object> searchParams = new HashMap<String, Object>();
                searchParams.put("EQ_code", vo.getEntity().getCode());
                requestList.setSearchParams(searchParams);
                KlfCityListResponse responseList = klfCity.getKlfCityList(requestList);
                if(responseList.getObjectList()!=null && responseList.getObjectList().size()>0){
                    throw new Exception("城市代号已经存在,请添加后缀后保存!");
                }
                
                KlfCityResponse response = klfCity.addKlfCity(request);
                Integer id = response.getEntity().getId();
                return "redirect:/klfcity/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除KlfCity
	 * 
	 * @param id KlfCity页面表单对象唯一标识
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id, HttpSession session){
	    
	    
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    KlfCityEntity entity = klfCity.getKlfCityById(Integer.valueOf(ids[i])).getEntity();
                    klfCity.deleteKlfCityById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                KlfCityEntity entity = klfCity.getKlfCityById(Integer.valueOf(id)).getEntity();
                klfCity.deleteKlfCityById(Integer.valueOf(id));
            }
        }
	    
       
	}

	/**
	 * 去查看KlfCity
	 * 
	 * @param id
	 *            KlfCity页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        KlfCityResponse response = klfCity
                .getKlfCityById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改KlfCity
	 * 
	 * @param id KlfCity页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        KlfCityResponse response = klfCity
                .getKlfCityById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改KlfCity
	 * 
	 * @param klfCity KlfCity页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateKlfCity(@Valid KlfCityVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		KlfCityEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                KlfCityRequest request = new KlfCityRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                KlfCityResponse rersponse = klfCity
                        .updateKlfCity(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/klfcity/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询KlfCity
	 * 
	 * @param klfCity KlfCity页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page(Page.TWENTY_PAGE_SIZE);
		if (null != number) {
			page.setCurrentPage(number);
		}
		KlfCityListRequest listRequest = new KlfCityListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        KlfCityListResponse response = klfCity.getKlfCityList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("klfCitys", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
