/**
 * Description: CmInviteRecord控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-10-15 上午 09:33:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-10-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.CmInviteRecordEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.CmInviteRecordVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.CmInviteRecordListRequest;
import com.house365.ws.beans.request.CmInviteRecordRequest;
import com.house365.ws.beans.response.CmInviteRecordListResponse;
import com.house365.ws.beans.response.CmInviteRecordResponse;
import com.house365.ws.interfaces.server.ICmInviteRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * CmInviteRecord控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-10-15
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cminviterecord")
public class CmInviteRecordController extends BaseController {

    /**
     * 自动注入CmInviteRecordWS实现
     */
    @Autowired
    private ICmInviteRecord cmInviteRecord;

    /**
     * 去新增CmInviteRecord
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增CmInviteRecord
     *
     * @param vo     CmInviteRecord页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createCmInviteRecord(@Valid CmInviteRecordVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        CmInviteRecordEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmInviteRecordRequest request = new CmInviteRecordRequest();
                request.setEntity(entity);
                CmInviteRecordResponse response = cmInviteRecord.addCmInviteRecord(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cminviterecord/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除CmInviteRecord
     *
     * @param id CmInviteRecord页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    cmInviteRecord.deleteCmInviteRecordById(Integer.valueOf(ids[i]));
                }
            } else {
                cmInviteRecord.deleteCmInviteRecordById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看CmInviteRecord
     *
     * @param id CmInviteRecord页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmInviteRecordResponse response = cmInviteRecord.getCmInviteRecordById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改CmInviteRecord
     *
     * @param id CmInviteRecord页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        CmInviteRecordResponse response = cmInviteRecord.getCmInviteRecordById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改CmInviteRecord
     *
     * @param vo     CmInviteRecord页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateCmInviteRecord(@Valid CmInviteRecordVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        CmInviteRecordEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmInviteRecordRequest request = new CmInviteRecordRequest();
                request.setEntity(entity);
                cmInviteRecord.updateCmInviteRecord(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cminviterecord/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询CmInviteRecord
     *
     * @param number  CmInviteRecord页面表单对象
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page(Page.TWENTY_PAGE_SIZE);
        if (null != number) {
            page.setCurrentPage(number);
        }
        CmInviteRecordListRequest listRequest = new CmInviteRecordListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmInviteRecordListResponse response = cmInviteRecord.getCmInviteRecordList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmInviteRecords", response.getObjectList());
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
