/**
 * Description: CmHouse控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:14
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.entity.CmHouseEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.CmHouseVo;
import com.house365.rest.context.CmConstant;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.CmHouseListRequest;
import com.house365.ws.beans.request.CmHouseRequest;
import com.house365.ws.beans.response.CmHouseListResponse;
import com.house365.ws.beans.response.CmHouseResponse;
import com.house365.ws.interfaces.server.ICmHouse;

/**
 * CmHouse控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmhouse")
public class CmHouseController extends BaseController {

	/**
	 * 自动注入CmHouseWS实现
	 */
	@Autowired
	private ICmHouse cmHouse;

	/**
	 * 去新增CmHouse
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增CmHouse
	 * 
	 * @param cmHouse CmHouse页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createCmHouse(@Valid CmHouseVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		CmHouseEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                CmHouseRequest request = new CmHouseRequest();
                request.setEntity(entity);
                CmHouseResponse response = cmHouse
                        .addCmHouse(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmhouse/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除CmHouse
	 * 
	 * @param id CmHouse页面表单对象唯一标识
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmHouseResponse response = cmHouse.deleteCmHouseById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                CmHouseResponse response = cmHouse.deleteCmHouseById(Integer.valueOf(id));
            }
        }
	}

	/**
	 * 去查看CmHouse
	 * 
	 * @param id
	 *            CmHouse页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmHouseResponse response = cmHouse
                .getCmHouseById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改CmHouse
	 * 
	 * @param id CmHouse页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        CmHouseResponse response = cmHouse
                .getCmHouseById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改CmHouse
	 * 
	 * @param cmHouse CmHouse页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateCmHouse(@Valid CmHouseVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		CmHouseEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                CmHouseRequest request = new CmHouseRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmHouseResponse rersponse = cmHouse
                        .updateCmHouse(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmhouse/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询CmHouse
	 * 
	 * @param cmHouse CmHouse页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (HttpSession httpSession, Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page(Page.TWENTY_PAGE_SIZE);
		if (null != number) {
			page.setCurrentPage(number);
		}
		//如果不是管理员，则按城市查询
		String userRole = httpSession.getAttribute("userRole").toString();
		if(!userRole.equals(CmConstant.ROLE_ADMIN)){
		    searchParams.put("EQ_cityKey", httpSession.getAttribute("cityKey").toString());
		}
		CmHouseListRequest listRequest = new CmHouseListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmHouseListResponse response = cmHouse.getCmHouseList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmHouses", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
