/**
 * Description: CmDictionary控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.system.Page;

import com.house365.beans.entity.CmDictionaryEntity;
import com.house365.beans.vo.CmDictionaryVo;

import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CmBrokerLabelResponse;

import com.house365.ws.beans.request.CmDictionaryListRequest;
import com.house365.ws.beans.request.CmDictionaryRequest;
import com.house365.ws.beans.response.CmDictionaryListResponse;
import com.house365.ws.beans.response.CmDictionaryResponse;
import com.house365.ws.interfaces.server.ICmDictionary;

/**
 * CmDictionary控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmdictionary")
public class CmDictionaryController extends BaseController {

    /**
     * 自动注入CmDictionaryWS实现
     */
    @Autowired
    private ICmDictionary cmDictionary;

    /**
     * 去新增CmDictionary
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增CmDictionary
     *
     * @param cmDictionary CmDictionary页面表单对象
     * @param result       表单验证数据
     * @param page         分页配置
     * @param request      请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createCmDictionary(
        @Valid CmDictionaryVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model
    ) {
        CmDictionaryEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmDictionaryRequest request = new CmDictionaryRequest();
                request.setEntity(entity);
                CmDictionaryResponse response = cmDictionary.addCmDictionary(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmdictionary/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除CmDictionary
     *
     * @param id      CmDictionary页面表单对象唯一标识
     * @param page    分页配置
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmDictionaryResponse response = cmDictionary.deleteCmDictionaryById(Integer.valueOf(ids[i]));
                }
            } else {
                CmDictionaryResponse response = cmDictionary.deleteCmDictionaryById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看CmDictionary
     *
     * @param id      CmDictionary页面表单对象唯一标识
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmDictionaryResponse response = cmDictionary.getCmDictionaryById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改CmDictionary
     *
     * @param id      CmDictionary页面表单对象唯一标识
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        CmDictionaryResponse response = cmDictionary.getCmDictionaryById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改CmDictionary
     *
     * @param cmDictionary CmDictionary页面表单对象
     * @param result       表单验证数据
     * @param page         分页配置
     * @param request      请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateCmDictionary(
        @Valid CmDictionaryVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes,
        Model model
    ) {
        CmDictionaryEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmDictionaryRequest request = new CmDictionaryRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused") CmDictionaryResponse rersponse = cmDictionary.updateCmDictionary(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmdictionary/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询CmDictionary
     *
     * @param request      请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        CmDictionaryListRequest listRequest = new CmDictionaryListRequest();
        listRequest.setPaging(page);
        searchParams.put("EQ_dicKey", "sign_remind");
        listRequest.setSearchParams(searchParams);
        CmDictionaryListResponse response = cmDictionary.getCmDictionaryList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmDictionarys", response.getObjectList());
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
