/**
 * Description: CmCreditAddRecord控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:08
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.system.Page;

import com.house365.beans.entity.CmCreditAddRecordEntity;
import com.house365.beans.vo.CmCreditAddRecordVo;

import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CmBrokerLabelResponse;

import com.house365.ws.beans.request.CmCreditAddRecordListRequest;
import com.house365.ws.beans.request.CmCreditAddRecordRequest;
import com.house365.ws.beans.response.CmCreditAddRecordListResponse;
import com.house365.ws.beans.response.CmCreditAddRecordResponse;
import com.house365.ws.interfaces.server.ICmCreditAddRecord;

/**
 * CmCreditAddRecord控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmcreditaddrecord")
public class CmCreditAddRecordController extends BaseController {

	/**
	 * 自动注入CmCreditAddRecordWS实现
	 */
	@Autowired
	private ICmCreditAddRecord cmCreditAddRecord;

	/**
	 * 去新增CmCreditAddRecord
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增CmCreditAddRecord
	 * 
	 * @param cmCreditAddRecord CmCreditAddRecord页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createCmCreditAddRecord(@Valid CmCreditAddRecordVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		CmCreditAddRecordEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                CmCreditAddRecordRequest request = new CmCreditAddRecordRequest();
                request.setEntity(entity);
                CmCreditAddRecordResponse response = cmCreditAddRecord
                        .addCmCreditAddRecord(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmcreditaddrecord/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除CmCreditAddRecord
	 * 
	 * @param id CmCreditAddRecord页面表单对象唯一标识
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmCreditAddRecordResponse response = cmCreditAddRecord.deleteCmCreditAddRecordById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                CmCreditAddRecordResponse response = cmCreditAddRecord.deleteCmCreditAddRecordById(Integer.valueOf(id));
            }
        }
	}

	/**
	 * 去查看CmCreditAddRecord
	 * 
	 * @param id
	 *            CmCreditAddRecord页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmCreditAddRecordResponse response = cmCreditAddRecord
                .getCmCreditAddRecordById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改CmCreditAddRecord
	 * 
	 * @param id CmCreditAddRecord页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        CmCreditAddRecordResponse response = cmCreditAddRecord
                .getCmCreditAddRecordById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改CmCreditAddRecord
	 * 
	 * @param cmCreditAddRecord CmCreditAddRecord页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateCmCreditAddRecord(@Valid CmCreditAddRecordVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		CmCreditAddRecordEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                CmCreditAddRecordRequest request = new CmCreditAddRecordRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmCreditAddRecordResponse rersponse = cmCreditAddRecord
                        .updateCmCreditAddRecord(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmcreditaddrecord/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询CmCreditAddRecord
	 * 
	 * @param cmCreditAddRecord CmCreditAddRecord页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page(Page.TWENTY_PAGE_SIZE);
		if (null != number) {
			page.setCurrentPage(number);
		}
		CmCreditAddRecordListRequest listRequest = new CmCreditAddRecordListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmCreditAddRecordListResponse response = cmCreditAddRecord.getCmCreditAddRecordList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmCreditAddRecords", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
