/**
 * Description: CmOrder页面表单对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.entity.CmUserEntity;

/**
 * CmOrder页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmOrderVo{
	/**
	 * CmOrder实体
	 */
    @NotNull
    @Valid
	private CmOrderEntity entity;
    
    private CmUserEntity userEntity;
    
    private CmCreditGoodsEntity creditGoodsEntity;
    
    private CmCreditRecordEntity creditRecordEntity;

	/**
	 * 设置CmOrder实体
	 * @param entity CmOrder实体
	 */
	public void setEntity(CmOrderEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取CmOrder实体
	 * @return CmOrder实体
	 */
	public CmOrderEntity getEntity() {
		return this.entity;
	}

	public CmUserEntity getUserEntity() {
		return userEntity;
	}

	public void setUserEntity(CmUserEntity userEntity) {
		this.userEntity = userEntity;
	}

	public CmCreditGoodsEntity getCreditGoodsEntity() {
		return creditGoodsEntity;
	}

	public void setCreditGoodsEntity(CmCreditGoodsEntity creditGoodsEntity) {
		this.creditGoodsEntity = creditGoodsEntity;
	}

	public CmCreditRecordEntity getCreditRecordEntity() {
		return creditRecordEntity;
	}

	public void setCreditRecordEntity(CmCreditRecordEntity creditRecordEntity) {
		this.creditRecordEntity = creditRecordEntity;
	}
	
}