/**
 * Description: 只包含楼盘和经纪人评论删除后的扣分页面表单对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:10
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CmCreditRemoveRecordEntity;

/**
 * 只包含楼盘和经纪人评论删除后的扣分页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmCreditRemoveRecordVo{
	/**
	 * 只包含楼盘和经纪人评论删除后的扣分实体
	 */
    @NotNull
    @Valid
	private CmCreditRemoveRecordEntity entity;
	

	/**
	 * 设置只包含楼盘和经纪人评论删除后的扣分实体
	 * @param entity 只包含楼盘和经纪人评论删除后的扣分实体
	 */
	public void setEntity(CmCreditRemoveRecordEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取只包含楼盘和经纪人评论删除后的扣分实体
	 * @return 只包含楼盘和经纪人评论删除后的扣分实体
	 */
	public CmCreditRemoveRecordEntity getEntity() {
		return this.entity;
	}
}