/**
 * Description: IfReg数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     house365
 * @author:     duhui
 * @version:    1.0
 * Create at:   2015-01-24 下午 13:56:27
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2012-12-21   duhui   1.0         Initial
 */
package com.house365.beans.po;

import javax.validation.constraints.*;

import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.house365.beans.system.DomainObject;

/**
 * IfReg数据库实体/领域对象<br>
 * 
 * @author duhui
 * @version 1.0, 2015-01-24
 * @see
 * @since 1.0
 */
public class IfRegPo extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 接口编码
	 */
	@Length(max=32)
	private String serviceCode;
	
	/**
	 * 接口名称
	 */
	@Length(max=32)
	private String serviceName;
	
	/**
     * 接口名称
     */
    @Length(max=32)
    private String serviceReg;
	
	/**
	 * 接口描述
	 */
	@Length(max=100)
	private String serviceDesc;
	
	/**
	 * 接口是否需要记录日志
	 */
	@Max(127)
	private Integer isLog;
	
	/**
	 * 接口是否需要监控
	 */
	@Max(127)
	private Integer isMonitor;
	
	/**
	 * 接口是否需要逻辑控制
	 */
	@Max(127)
	private Integer isControl;
	
	/**
	 * 接口版本
	 */
	@Length(max=32)
	private String version;
	
	/**
	 * 准许访问渠道
	 */
	@Length(max=32)
	private String channl;
	
	/**
	 * 备注
	 */
	@Length(max=100)
	private String remark;
	
	/**
	 * 设置接口编码
	 * @param serviceCode 接口编码
	 */
	public void setServiceCode(String serviceCode) {
		this.serviceCode = serviceCode;
	}

	/**
	 * 获取接口编码
	 * @return 接口编码
	 */
	public String getServiceCode() {
		return this.serviceCode;
	}

	/**
	 * 设置接口名称
	 * @param serviceName 接口名称
	 */
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	/**
	 * 获取接口名称
	 * @return 接口名称
	 */
	public String getServiceName() {
		return this.serviceName;
	}
	
    /**
     * 注入服务
     * @param serviceName 注入服务
     */
    public void setServiceReg(String serviceReg) {
        this.serviceReg = serviceReg;
    }

    /**
     * 获取注入服务
     * @return 注入服务
     */
    public String getServiceReg() {
        return this.serviceReg;
    }	

	/**
	 * 设置接口描述
	 * @param serviceDesc 接口描述
	 */
	public void setServiceDesc(String serviceDesc) {
		this.serviceDesc = serviceDesc;
	}

	/**
	 * 获取接口描述
	 * @return 接口描述
	 */
	public String getServiceDesc() {
		return this.serviceDesc;
	}

	/**
	 * 设置接口是否需要记录日志
	 * @param isLog 接口是否需要记录日志
	 */
	public void setIsLog(Integer isLog) {
		this.isLog = isLog;
	}

	/**
	 * 获取接口是否需要记录日志
	 * @return 接口是否需要记录日志
	 */
	public Integer getIsLog() {
		return this.isLog;
	}

	/**
	 * 设置接口是否需要监控
	 * @param isMonitor 接口是否需要监控
	 */
	public void setIsMonitor(Integer isMonitor) {
		this.isMonitor = isMonitor;
	}

	/**
	 * 获取接口是否需要监控
	 * @return 接口是否需要监控
	 */
	public Integer getIsMonitor() {
		return this.isMonitor;
	}

	/**
	 * 设置接口是否需要逻辑控制
	 * @param isControl 接口是否需要逻辑控制
	 */
	public void setIsControl(Integer isControl) {
		this.isControl = isControl;
	}

	/**
	 * 获取接口是否需要逻辑控制
	 * @return 接口是否需要逻辑控制
	 */
	public Integer getIsControl() {
		return this.isControl;
	}

	/**
	 * 设置接口版本
	 * @param version 接口版本
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * 获取接口版本
	 * @return 接口版本
	 */
	public String getVersion() {
		return this.version;
	}

	/**
	 * 设置准许访问渠道
	 * @param channl 准许访问渠道
	 */
	public void setChannl(String channl) {
		this.channl = channl;
	}

	/**
	 * 获取准许访问渠道
	 * @return 准许访问渠道
	 */
	public String getChannl() {
		return this.channl;
	}

	/**
	 * 设置备注
	 * @param remark 备注
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}

	/**
	 * 获取备注
	 * @return 备注
	 */
	public String getRemark() {
		return this.remark;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("ServiceCode",getServiceCode())
			.append("ServiceName",getServiceName())
			.append("ServiceDesc",getServiceDesc())
			.append("IsLog",getIsLog())
			.append("IsMonitor",getIsMonitor())
			.append("IsControl",getIsControl())
			.append("Version",getVersion())
			.append("Channl",getChannl())
			.append("Remark",getRemark())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof IfRegPo == false) return false;
		if(this == obj) return true;
		IfRegPo other = (IfRegPo)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

