/**
 * Description: CmSeckillRemind数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-29 下午 14:08:45
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import com.house365.beans.system.DomainObject;

/**
 * CmSeckillRemind数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
public class CmSeckillRemindEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 用户编号
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String userId;
	
	/**
	 * 用户手机
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String userPhone;
	
	/**
	 * 商品ID
	 */
	
	private Integer goodId;
	
	/**
	 * 提醒时间
	 */
	private Date remindTime;
	
	/**
	 * 创建时间
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String createTime;
	
	/**
	 * 状态 0:未提醒 1:已提醒
	 */
	
	private Integer status;
	
	//columns END
	/*
	public CmSeckillRemind(){
	}

	public CmSeckillRemind(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置用户编号
	 * @param userId 用户编号
	 */
	public void setUserId(String userId) {
		this.userId = userId;
	}

	/**
	 * 获取用户编号
	 * @return 用户编号
	 */
	public String getUserId() {
		return this.userId;
	}

	/**
	 * 设置用户手机
	 * @param userPhone 用户手机
	 */
	public void setUserPhone(String userPhone) {
		this.userPhone = userPhone;
	}

	/**
	 * 获取用户手机
	 * @return 用户手机
	 */
	public String getUserPhone() {
		return this.userPhone;
	}

    public Date getRemindTime() {
        return remindTime;
    }

    public void setRemindTime(Date remindTime) {
        this.remindTime = remindTime;
    }

    /**
	 * 设置商品ID
	 * @param goodId 商品ID
	 */
	public void setGoodId(Integer goodId) {
		this.goodId = goodId;
	}

	/**
	 * 获取商品ID
	 * @return 商品ID
	 */
	public Integer getGoodId() {
		return this.goodId;
	}



	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置状态 0:未提醒 1:已提醒
	 * @param status 状态 0:未提醒 1:已提醒
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 获取状态 0:未提醒 1:已提醒
	 * @return 状态 0:未提醒 1:已提醒
	 */
	public Integer getStatus() {
		return this.status;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("UserPhone",getUserPhone())
			.append("GoodId",getGoodId())
			.append("RemindTime",getRemindTime())
			.append("CreateTime",getCreateTime())
			.append("Status",getStatus())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmSeckillRemindEntity == false) return false;
		if(this == obj) return true;
		CmSeckillRemindEntity other = (CmSeckillRemindEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

