/**
 * Description: CmPromotion数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 上午 10:52:43
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmPromotion数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
public class CmPromotionEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * name
	 */
	@NotBlank @Length(max=100, message="长度需要大于0且小于100")
	private String name;
	
	/**
	 * description
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String description;
	
	/**
	 * 1 有效 0 无效
	 */
	@NotNull 
	private Integer status;
	
	/**
	 * startTime
	 */
	
	private java.util.Date startTime;
	
	/**
	 * endTime
	 */
	
	private java.util.Date endTime;
	
	/**
	 * city
	 */
	@Length(max=500, message="长度需要大于0且小于500")
	private String city;
	
	/**
	 * creater
	 */
	@Length(max=45, message="长度需要大于0且小于45")
	private String creater;
	
	/**
	 * createTime
	 */
	@NotNull 
	private java.util.Date createTime;
	
	//columns END
	/*
	public CmPromotion(){
	}

	public CmPromotion(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置name
	 * @param name name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 获取name
	 * @return name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * 设置description
	 * @param description description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 获取description
	 * @return description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * 设置1 有效 0 无效
	 * @param status 1 有效 0 无效
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 获取1 有效 0 无效
	 * @return 1 有效 0 无效
	 */
	public Integer getStatus() {
		return this.status;
	}

	/**
	 * 设置startTime
	 * @param startTime startTime
	 */
	public void setStartTime(java.util.Date startTime) {
		this.startTime = startTime;
	}

	/**
	 * 设置startTime字符串格式
	 * @param startTime startTime
	 */
	public void setStartTimeStr(String startTime) {
		if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
			try {
				this.startTime = java.text.DateFormat.getDateTimeInstance().parse(startTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取startTime
	 * @return startTime
	 */
	public java.util.Date getStartTime() {
		return this.startTime;
	}

	/**
	 * 设置endTime
	 * @param endTime endTime
	 */
	public void setEndTime(java.util.Date endTime) {
		this.endTime = endTime;
	}

	/**
	 * 设置endTime字符串格式
	 * @param endTime endTime
	 */
	public void setEndTimeStr(String endTime) {
		if (!com.house365.web.util.StringUtils.isBlank(endTime)) {
			try {
				this.endTime = java.text.DateFormat.getDateTimeInstance().parse(endTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取endTime
	 * @return endTime
	 */
	public java.util.Date getEndTime() {
		return this.endTime;
	}

	/**
	 * 设置city
	 * @param city city
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/**
	 * 获取city
	 * @return city
	 */
	public String getCity() {
		return this.city;
	}

	/**
	 * 设置creater
	 * @param creater creater
	 */
	public void setCreater(String creater) {
		this.creater = creater;
	}

	/**
	 * 获取creater
	 * @return creater
	 */
	public String getCreater() {
		return this.creater;
	}

	/**
	 * 设置createTime
	 * @param createTime createTime
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置createTime字符串格式
	 * @param createTime createTime
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取createTime
	 * @return createTime
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("Name",getName())
			.append("Description",getDescription())
			.append("Status",getStatus())
			.append("StartTime",getStartTime())
			.append("EndTime",getEndTime())
			.append("City",getCity())
			.append("Creater",getCreater())
			.append("CreateTime",getCreateTime())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmPromotionEntity == false) return false;
		if(this == obj) return true;
		CmPromotionEntity other = (CmPromotionEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

