/**
 * Description: CmProductStat数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-03-16 下午 17:11:49
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-03-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmProductStat数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-03-16
 * @see
 * @since 1.0
 */
public class CmProductStatEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * productId
     */
    //    @NotNull
    private Integer productId;

    /**
     * productName
     */
    //    @NotBlank
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String productName;

    /**
     * 期初库存
     */
    //    @NotNull
    private Integer beginStock;

    /**
     * 期末库存
     */
    //    @NotNull
    private Integer endStock;

    /**
     * yyyy-MM-dd
     */
    //    @NotBlank
    //    @Length(max = 10, message = "长度需要大于0且小于10")
    private String statDate;

    /**
     * 商品类型 0:实物 1:虚拟
     */
    //    @NotNull
    private Integer productType;

    /**
     * 数据来源 1 上架商品 2 日常统计
     */
    //    @NotNull
    private Integer source;

    /**
     * city
     */
    //    @NotBlank
    //    @Length(max = 20, message = "长度需要大于0且小于20")
    private String city;

    /**
     * 是否为秒杀商品 0:不是 1:是
     */
    //    @NotNull
    private Integer isSeckill;

    /**
     * seckillStartTime
     */

    private java.util.Date seckillStartTime;

    /**
     * seckillEndTime
     */

    private java.util.Date seckillEndTime;

    /**
     * createTime
     */

    private java.util.Date createTime;

    private String cityName;

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    //columns END
  /*
  public CmProductStat(){
	}

	public CmProductStat(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置productId
     *
     * @param productId productId
     */
    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    /**
     * 获取productId
     *
     * @return productId
     */
    public Integer getProductId() {
        return this.productId;
    }

    /**
     * 设置productName
     *
     * @param productName productName
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取productName
     *
     * @return productName
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 设置期初库存
     *
     * @param beginStock 期初库存
     */
    public void setBeginStock(Integer beginStock) {
        this.beginStock = beginStock;
    }

    /**
     * 获取期初库存
     *
     * @return 期初库存
     */
    public Integer getBeginStock() {
        return this.beginStock;
    }

    /**
     * 设置期末库存
     *
     * @param endStock 期末库存
     */
    public void setEndStock(Integer endStock) {
        this.endStock = endStock;
    }

    /**
     * 获取期末库存
     *
     * @return 期末库存
     */
    public Integer getEndStock() {
        return this.endStock;
    }

    /**
     * 设置yyyy-MM-dd
     *
     * @param statDate yyyy-MM-dd
     */
    public void setStatDate(String statDate) {
        this.statDate = statDate;
    }

    /**
     * 获取yyyy-MM-dd
     *
     * @return yyyy-MM-dd
     */
    public String getStatDate() {
        return this.statDate;
    }

    /**
     * 设置商品类型 0:实物 1:虚拟
     *
     * @param productType 商品类型 0:实物 1:虚拟
     */
    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    /**
     * 获取商品类型 0:实物 1:虚拟
     *
     * @return 商品类型 0:实物 1:虚拟
     */
    public Integer getProductType() {
        return this.productType;
    }

    /**
     * 设置数据来源 1 上架商品 2 日常统计
     *
     * @param source 数据来源 1 上架商品 2 日常统计
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 获取数据来源 1 上架商品 2 日常统计
     *
     * @return 数据来源 1 上架商品 2 日常统计
     */
    public Integer getSource() {
        return this.source;
    }

    /**
     * 设置city
     *
     * @param city city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取city
     *
     * @return city
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置是否为秒杀商品 0:不是 1:是
     *
     * @param isSeckill 是否为秒杀商品 0:不是 1:是
     */
    public void setIsSeckill(Integer isSeckill) {
        this.isSeckill = isSeckill;
    }

    /**
     * 获取是否为秒杀商品 0:不是 1:是
     *
     * @return 是否为秒杀商品 0:不是 1:是
     */
    public Integer getIsSeckill() {
        return this.isSeckill;
    }

    /**
     * 设置seckillStartTime
     *
     * @param seckillStartTime seckillStartTime
     */
    public void setSeckillStartTime(java.util.Date seckillStartTime) {
        this.seckillStartTime = seckillStartTime;
    }

    /**
     * 设置seckillStartTime字符串格式
     *
     * @param seckillStartTime seckillStartTime
     */
    public void setSeckillStartTimeStr(String seckillStartTime) {
        if (!com.house365.web.util.StringUtils.isBlank(seckillStartTime)) {
            try {
                this.seckillStartTime = java.text.DateFormat.getDateTimeInstance().parse(seckillStartTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取seckillStartTime
     *
     * @return seckillStartTime
     */
    public java.util.Date getSeckillStartTime() {
        return this.seckillStartTime;
    }

    /**
     * 设置seckillEndTime
     *
     * @param seckillEndTime seckillEndTime
     */
    public void setSeckillEndTime(java.util.Date seckillEndTime) {
        this.seckillEndTime = seckillEndTime;
    }

    /**
     * 设置seckillEndTime字符串格式
     *
     * @param seckillEndTime seckillEndTime
     */
    public void setSeckillEndTimeStr(String seckillEndTime) {
        if (!com.house365.web.util.StringUtils.isBlank(seckillEndTime)) {
            try {
                this.seckillEndTime = java.text.DateFormat.getDateTimeInstance().parse(seckillEndTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取seckillEndTime
     *
     * @return seckillEndTime
     */
    public java.util.Date getSeckillEndTime() {
        return this.seckillEndTime;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ProductId",
                                                                                                      getProductId()).append(
            "ProductName", getProductName()).append("BeginStock", getBeginStock()).append("EndStock",
                                                                                          getEndStock()).append(
            "StatDate", getStatDate()).append("ProductType", getProductType()).append("Source", getSource()).append(
            "City", getCity()).append("IsSeckill", getIsSeckill()).append("SeckillStartTime",
                                                                          getSeckillStartTime()).append(
            "SeckillEndTime", getSeckillEndTime()).append("CreateTime", getCreateTime()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmProductStatEntity == false)
            return false;
        if (this == obj)
            return true;
        CmProductStatEntity other = (CmProductStatEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

