/**
 * Description: CmOrder数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:17
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import com.house365.beans.system.DomainObject;

/**
 * CmOrder数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmOrderEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 下单时间
     */

    private java.util.Date createTime;

    /**
     * 会员ID
     */

    private Integer userId;

    /**
     * 会员名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String userName;

    /**
     * 会员手机
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String userPhone;

    /**
     * 配送方式
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String deliverType;

    /**
     * 收货人姓名
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String receiverName;

    /**
     * 收货人手机
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String receiverPhone;

    /**
     * 收货人区域
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String receiverArea;

    /**
     * 收货人详细地址
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String receiverDetailAddress;

    /**
     * 收货邮编
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String receiverZipCode;

    /**
     * 消耗积分
     */

    private Integer credits;

    /**
     * 被交换的商品数量
     */
    private Integer exchangedCount;

    /**
     * 已经被兑换的商品总数
     */
    private Integer totolSendedGoods;

    /**
     * 订单状态
     */

    private Integer orderStatus;

    /**
     * 快递公司
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String expressCompany;

    /**
     * 运单号
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String oerderNumber;

    /**
     * 城市编号
     */

    private Integer cityId;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 城市主键
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityKey;

    /**
     * 是否删除0:未删除
     */

    private Integer isDeleted;

    /**
     * 商品id
     */

    private Integer goodsId;

    /**
     * 商品名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String goodsName;

    /**
     * 商品数量
     */

    private Integer goodsAmount;

    /**
     * 商品图片
     */
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String goodsPicture;

    /**
     * 商品类型 1 虚拟 0 实物 2 第三方
     */

    private Integer goodsType;

    /**
     * 商品积分数量
     */

    private Integer goodsCreditAmount;

    /**
     * 商品总积分数量
     */

    private Integer goodsTotalCreditAmount;

    /**
     * 发货时间
     */

    private java.util.Date deliverTime;

    /**
     * 收货时间
     */
    private java.util.Date receiveTime;

    private String createDateTime;

    private String deliverDateTime;

    private String receiveDateTime;

    //1 秒杀订单 0 普通订单
    private Integer isSeckill;

    public Integer getIsSeckill() {
        return isSeckill;
    }

    public void setIsSeckill(Integer isSeckill) {
        this.isSeckill = isSeckill;
    }

    /**
     * 设置下单时间
     * @param createTime 下单时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    public Integer getExchangedCount() {
        return exchangedCount;
    }

    public void setExchangedCount(Integer exchangedCount) {
        this.exchangedCount = exchangedCount;
    }


    public Integer getTotolSendedGoods() {
        return totolSendedGoods;
    }

    public void setTotolSendedGoods(Integer totolSendedGoods) {
        this.totolSendedGoods = totolSendedGoods;
    }

    /**
     * 设置下单时间字符串格式
     * @param createTime 下单时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取下单时间
     * @return 下单时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置会员ID
     * @param userId 会员ID
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取会员ID
     * @return 会员ID
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置会员名称
     * @param userName 会员名称
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取会员名称
     * @return 会员名称
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置会员手机
     * @param userPhone 会员手机
     */
    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    /**
     * 获取会员手机
     * @return 会员手机
     */
    public String getUserPhone() {
        return this.userPhone;
    }

    /**
     * 设置配送方式
     * @param deliverType 配送方式
     */
    public void setDeliverType(String deliverType) {
        this.deliverType = deliverType;
    }

    /**
     * 获取配送方式
     * @return 配送方式
     */
    public String getDeliverType() {
        return this.deliverType;
    }

    /**
     * 设置收货人姓名
     * @param receiverName 收货人姓名
     */
    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    /**
     * 获取收货人姓名
     * @return 收货人姓名
     */
    public String getReceiverName() {
        return this.receiverName;
    }

    /**
     * 设置收货人手机
     * @param receiverPhone 收货人手机
     */
    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    /**
     * 获取收货人手机
     * @return 收货人手机
     */
    public String getReceiverPhone() {
        return this.receiverPhone;
    }

    /**
     * 设置收货人区域
     * @param receiverArea 收货人区域
     */
    public void setReceiverArea(String receiverArea) {
        this.receiverArea = receiverArea;
    }

    /**
     * 获取收货人区域
     * @return 收货人区域
     */
    public String getReceiverArea() {
        return this.receiverArea;
    }

    /**
     * 设置收货人详细地址
     * @param receiverDetailAddress 收货人详细地址
     */
    public void setReceiverDetailAddress(String receiverDetailAddress) {
        this.receiverDetailAddress = receiverDetailAddress;
    }

    /**
     * 获取收货人详细地址
     * @return 收货人详细地址
     */
    public String getReceiverDetailAddress() {
        return this.receiverDetailAddress;
    }

    /**
     * 设置收货邮编
     * @param receiverZipCode 收货邮编
     */
    public void setReceiverZipCode(String receiverZipCode) {
        this.receiverZipCode = receiverZipCode;
    }

    /**
     * 获取收货邮编
     * @return 收货邮编
     */
    public String getReceiverZipCode() {
        return this.receiverZipCode;
    }

    /**
     * 设置消耗积分
     * @param credits 消耗积分
     */
    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    /**
     * 获取消耗积分
     * @return 消耗积分
     */
    public Integer getCredits() {
        return this.credits;
    }

    /**
     * 设置订单状态
     * @param orderStatus 订单状态
     */
    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * 获取订单状态
     * @return 订单状态
     */
    public Integer getOrderStatus() {
        return this.orderStatus;
    }

    /**
     * 设置快递公司
     * @param expressCompany 快递公司
     */
    public void setExpressCompany(String expressCompany) {
        this.expressCompany = expressCompany;
    }

    /**
     * 获取快递公司
     * @return 快递公司
     */
    public String getExpressCompany() {
        return this.expressCompany;
    }

    /**
     * 设置运单号
     * @param oerderNumber 运单号
     */
    public void setOerderNumber(String oerderNumber) {
        this.oerderNumber = oerderNumber;
    }

    /**
     * 获取运单号
     * @return 运单号
     */
    public String getOerderNumber() {
        return this.oerderNumber;
    }

    /**
     * 设置城市编号
     * @param cityId 城市编号
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市编号
     * @return 城市编号
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市名称
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名称
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置是否删除0:未删除
     * @param isDeleted 是否删除0:未删除
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否删除0:未删除
     * @return 是否删除0:未删除
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置商品id
     * @param goodsId 商品id
     */
    public void setGoodsId(Integer goodsId) {
        this.goodsId = goodsId;
    }

    /**
     * 获取商品id
     * @return 商品id
     */
    public Integer getGoodsId() {
        return this.goodsId;
    }

    /**
     * 设置商品名称
     * @param goodsName 商品名称
     */
    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    /**
     * 获取商品名称
     * @return 商品名称
     */
    public String getGoodsName() {
        return this.goodsName;
    }

    /**
     * 设置商品数量
     * @param goodsAmount 商品数量
     */
    public void setGoodsAmount(Integer goodsAmount) {
        this.goodsAmount = goodsAmount;
    }

    /**
     * 获取商品数量
     * @return 商品数量
     */
    public Integer getGoodsAmount() {
        return this.goodsAmount;
    }

    /**
     * 设置商品图片
     * @param goodsPicture 商品图片
     */
    public void setGoodsPicture(String goodsPicture) {
        this.goodsPicture = goodsPicture;
    }

    /**
     * 获取商品图片
     * @return 商品图片
     */
    public String getGoodsPicture() {
        return this.goodsPicture;
    }

    /**
     * 设置商品积分数量
     * @param goodsCreditAmount 商品积分数量
     */
    public void setGoodsCreditAmount(Integer goodsCreditAmount) {
        this.goodsCreditAmount = goodsCreditAmount;
    }

    /**
     * 获取商品积分数量
     * @return 商品积分数量
     */
    public Integer getGoodsCreditAmount() {
        return this.goodsCreditAmount;
    }

    /**
     * 设置商品总积分数量
     * @param goodsTotalCreditAmount 商品总积分数量
     */
    public void setGoodsTotalCreditAmount(Integer goodsTotalCreditAmount) {
        this.goodsTotalCreditAmount = goodsTotalCreditAmount;
    }

    /**
     * 获取商品总积分数量
     * @return 商品总积分数量
     */
    public Integer getGoodsTotalCreditAmount() {
        return this.goodsTotalCreditAmount;
    }

    /**
     * 设置发货时间
     * @param deliverTime 发货时间
     */
    public void setDeliverTime(java.util.Date deliverTime) {
        this.deliverTime = deliverTime;
    }

    /**
     * 设置发货时间字符串格式
     * @param deliverTime 发货时间
     */
    public void setDeliverTimeStr(String deliverTime) {
        if (!com.house365.web.util.StringUtils.isBlank(deliverTime)) {
            try {
                this.deliverTime = java.text.DateFormat.getDateTimeInstance().parse(deliverTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取发货时间
     * @return 发货时间
     */
    public java.util.Date getDeliverTime() {
        return this.deliverTime;
    }

    /**
     * 设置收货时间
     * @param receiveTime 收货时间
     */
    public void setReceiveTime(java.util.Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    /**
     * 设置收货时间字符串格式
     * @param receiveTime 收货时间
     */
    public void setReceiveTimeStr(String receiveTime) {
        if (!com.house365.web.util.StringUtils.isBlank(receiveTime)) {
            try {
                this.receiveTime = java.text.DateFormat.getDateTimeInstance().parse(receiveTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取收货时间
     * @return 收货时间
     */
    public java.util.Date getReceiveTime() {
        return this.receiveTime;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CmOrderEntity{");
        sb.append("id=").append(getId());
        sb.append("createTime=").append(createTime);
        sb.append(", userId=").append(userId);
        sb.append(", userName='").append(userName).append('\'');
        sb.append(", userPhone='").append(userPhone).append('\'');
        sb.append(", deliverType='").append(deliverType).append('\'');
        sb.append(", receiverName='").append(receiverName).append('\'');
        sb.append(", receiverPhone='").append(receiverPhone).append('\'');
        sb.append(", receiverArea='").append(receiverArea).append('\'');
        sb.append(", receiverDetailAddress='").append(receiverDetailAddress).append('\'');
        sb.append(", receiverZipCode='").append(receiverZipCode).append('\'');
        sb.append(", credits=").append(credits);
        sb.append(", exchangedCount=").append(exchangedCount);
        sb.append(", totolSendedGoods=").append(totolSendedGoods);
        sb.append(", orderStatus=").append(orderStatus);
        sb.append(", expressCompany='").append(expressCompany).append('\'');
        sb.append(", oerderNumber='").append(oerderNumber).append('\'');
        sb.append(", cityId=").append(cityId);
        sb.append(", cityName='").append(cityName).append('\'');
        sb.append(", cityKey='").append(cityKey).append('\'');
        sb.append(", isDeleted=").append(isDeleted);
        sb.append(", goodsId=").append(goodsId);
        sb.append(", goodsName='").append(goodsName).append('\'');
        sb.append(", goodsAmount=").append(goodsAmount);
        sb.append(", goodsPicture='").append(goodsPicture).append('\'');
        sb.append(", goodsType=").append(goodsType);
        sb.append(", goodsCreditAmount=").append(goodsCreditAmount);
        sb.append(", goodsTotalCreditAmount=").append(goodsTotalCreditAmount);
        sb.append(", deliverTime=").append(deliverTime);
        sb.append(", receiveTime=").append(receiveTime);
        sb.append(", createDateTime='").append(createDateTime).append('\'');
        sb.append(", deliverDateTime='").append(deliverDateTime).append('\'');
        sb.append(", receiveDateTime='").append(receiveDateTime).append('\'');
        sb.append(", isSeckill=").append(isSeckill);
        sb.append('}');
        return sb.toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmOrderEntity == false)
            return false;
        if (this == obj)
            return true;
        CmOrderEntity other = (CmOrderEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    public String getCreateDateTime() {
        return createDateTime;
    }

    public void setCreateDateTime(String createDateTime) {
        this.createDateTime = createDateTime;
    }

    public String getDeliverDateTime() {
        return deliverDateTime;
    }

    public void setDeliverDateTime(String deliverDateTime) {
        this.deliverDateTime = deliverDateTime;
    }

    public String getReceiveDateTime() {
        return receiveDateTime;
    }

    public void setReceiveDateTime(String receiveDateTime) {
        this.receiveDateTime = receiveDateTime;
    }

}

