/**
 * Description: CmLotteryRule数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-19 上午 11:24:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-19   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * CmLotteryRule数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-19
 * @see
 * @since 1.0
 */
public class CmLotteryRuleEntity extends DomainObject implements Comparable<CmLotteryRuleEntity> {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 积分数量
     */
    private Integer credits;

    /**
     * 奖品名称
     */

    @Length(max = 100, message = "长度需要大于0且小于100")
    private String creditRuleName;

    /**
     * 中奖概率(小数表示)
     */

    private Float probability;

    /**
     * 所属城市
     */

    private Integer cityId;

    /**
     * 所属城市名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String cityName;

    /**
     * 城市编码
     */
    private String cityKey;

    /**
     * 创建时间
     */

    private java.util.Date createTime;

    /**
     * 更新时间
     */

    private java.util.Date updateTime;

    /**
     * 排序
     */
    private Integer orderNumber;

    /**
     * 用户积分
     */
    private Integer userCredits;

    public Integer getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * 设置中奖概率(小数表示)
     *
     * @param probability 中奖概率(小数表示)
     */
    public void setProbability(Float probability) {
        this.probability = probability;
    }

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public String getCreditRuleName() {
        return creditRuleName;
    }

    public void setCreditRuleName(String creditRuleName) {
        this.creditRuleName = creditRuleName;
    }

    /**
     * 获取中奖概率(小数表示)
     *
     * @return 中奖概率(小数表示)
     */
    public Float getProbability() {
        return this.probability;
    }

    /**
     * 设置所属城市
     *
     * @param cityId 所属城市
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取所属城市
     *
     * @return 所属城市
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置所属城市名称
     *
     * @param cityName 所属城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取所属城市名称
     *
     * @return 所属城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置更新时间
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置更新时间字符串格式
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新时间
     *
     * @return 更新时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    public Integer getUserCredits() {
        return userCredits;
    }

    public void setUserCredits(Integer userCredits) {
        this.userCredits = userCredits;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Credits", getCredits())
                .append("CreditRuleName", getCreditRuleName())
                .append("Probability", getProbability())
                .append("CityId", getCityId())
                .append("CityName", getCityName())
                .append("CreateTime", getCreateTime())
                .append("UpdateTime", getUpdateTime())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmLotteryRuleEntity == false) return false;
        if (this == obj) return true;
        CmLotteryRuleEntity other = (CmLotteryRuleEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }

    @Override
    public int compareTo(CmLotteryRuleEntity arg0) {
        return this.getProbability().compareTo(arg0.getProbability());
    }
}

