/**
 * Description: CmHouse数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:14
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;

import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmHouse数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmHouseEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 楼盘编号
	 */
	
	private Integer houseId;
	
	/**
	 * 楼盘名称
	 */
	@Length(max=50, message="长度需要大于0且小于50")
	private String houseName;
	
	/**
	 * 楼盘联系电话
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String housePhone;
	
	/**
	 * 价格评分
	 */
	
	private Float priceScore;
	
	/**
	 * 地段评分
	 */
	
	private Float placeScore;
	
	/**
	 * 交通评分
	 */
	
	private Float trafficScore;
	
	/**
	 * 配套评分
	 */
	
	private Float infrastructureScore;
	
	/**
	 * 环境评分
	 */
	
	private Float enviromentScore;
	
	/**
	 * 总点评数
	 */
	
	private Integer totolCommetAmount;
	
	/**
	 * 综合评分
	 */
	
	private Float integrationScore;
	
	/**
	 * 最早评论时间
	 */
	
	private java.util.Date earliestComment;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 有图评论数量
	 */
	private Integer withPictureCount;
	/**
	 * 无图评论数量
	 */
	private Integer noPictureCount;
	/**
	 * 加精数量
	 */
	private Integer excellentCount;
	/**
	 * 点赞数量
	 */
	private Integer praiseCount;
	
	/**
	 * 
	 * 功能描述: <br>
	 * 加精数量加一
	 *
	 * @author yinchangming
	 * @version [v1.0.0, 2015年10月21日]
	 * @since [产品/模块版本](可选)
	 */
	public void increaseExcellentCount(){
	    this.excellentCount = this.getWithPictureCount()+1;
	}
	/**
	 * 
	 * 功能描述: <br>
	 * 有图数量加一
	 *
	 * @author yinchangming
	 * @version [v1.0.0, 2015年10月21日]
	 * @since [产品/模块版本](可选)
	 */
	public void increaseWithPictureCount(){
	    this.withPictureCount = this.getWithPictureCount()+1;
	}
	/**
	 * 
	 * 功能描述: <br>
	 * 总量数量加一
	 *
	 * @author yinchangming
	 * @version [v1.0.0, 2015年10月21日]
	 * @since [产品/模块版本](可选)
	 */
	public void increaseTotolCommetAmount(){
	    this.totolCommetAmount = this.getTotolCommetAmount()+1;
	}
	
	/**
     * 
     * 功能描述: <br>
     * 加精数量加一
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年10月21日]
     * @since [产品/模块版本](可选)
     */
    public void decreaseExcellentCount(){
        this.excellentCount = this.getWithPictureCount()-1;
    }
    /**
     * 
     * 功能描述: <br>
     * 有图数量加一
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年10月21日]
     * @since [产品/模块版本](可选)
     */
    public void decreaseWithPictureCount(){
        this.withPictureCount = this.getWithPictureCount()-1;
    }
    /**
     * 
     * 功能描述: <br>
     * 总量数量加一
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年10月21日]
     * @since [产品/模块版本](可选)
     */
    public void decreaseTotolCommetAmount(){
        this.totolCommetAmount = this.getTotolCommetAmount()-1;
    }
	
	
	public Integer getWithPictureCount() {
	    if(this.withPictureCount==null){
	        this.withPictureCount=0;
	    }
        return this.withPictureCount;
    }

    public void setWithPictureCount(Integer withPictureCount) {
        this.withPictureCount = withPictureCount;
    }

    public Integer getNoPictureCount() {
        return noPictureCount;
    }

    public void setNoPictureCount(Integer noPictureCount) {
        this.noPictureCount = noPictureCount;
    }

    
    public Integer getExcellentCount() {
        if(this.excellentCount==null){
            this.excellentCount=0;
        }
        return this.excellentCount;
    }

    public void setExcellentCount(Integer excellentCount) {
        this.excellentCount = excellentCount;
    }

    public Integer getPraiseCount() {
        return praiseCount;
    }

    public void setPraiseCount(Integer praiseCount) {
        this.praiseCount = praiseCount;
    }

    /**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
	 * 楼盘
	 */
	private Integer channel;
	
	public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    /**
     * 城市key
     */
    @Length(max=20, message="长度需要大于0且小于20")
    private String cityKey;
    
    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }
	
	/**
	 * 是否删除 0:未删除 1:已删除
	 */
	
	private Integer isDeleted;
	
	//columns END
	/*
	public CmHouse(){
	}

	public CmHouse(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置楼盘编号
	 * @param houseId 楼盘编号
	 */
	public void setHouseId(Integer houseId) {
		this.houseId = houseId;
	}

	/**
	 * 获取楼盘编号
	 * @return 楼盘编号
	 */
	public Integer getHouseId() {
		return this.houseId;
	}

	/**
	 * 设置楼盘名称
	 * @param houseName 楼盘名称
	 */
	public void setHouseName(String houseName) {
		this.houseName = houseName;
	}

	/**
	 * 获取楼盘名称
	 * @return 楼盘名称
	 */
	public String getHouseName() {
		return this.houseName;
	}

	/**
	 * 设置楼盘联系电话
	 * @param housePhone 楼盘联系电话
	 */
	public void setHousePhone(String housePhone) {
		this.housePhone = housePhone;
	}

	/**
	 * 获取楼盘联系电话
	 * @return 楼盘联系电话
	 */
	public String getHousePhone() {
		return this.housePhone;
	}

	/**
	 * 设置价格评分
	 * @param priceScore 价格评分
	 */
	public void setPriceScore(Float priceScore) {
		this.priceScore = priceScore;
	}

	/**
	 * 获取价格评分
	 * @return 价格评分
	 */
	public Float getPriceScore() {
		return this.priceScore;
	}

	/**
	 * 设置地段评分
	 * @param placeScore 地段评分
	 */
	public void setPlaceScore(Float placeScore) {
		this.placeScore = placeScore;
	}

	/**
	 * 获取地段评分
	 * @return 地段评分
	 */
	public Float getPlaceScore() {
		return this.placeScore;
	}

	/**
	 * 设置交通评分
	 * @param trafficScore 交通评分
	 */
	public void setTrafficScore(Float trafficScore) {
		this.trafficScore = trafficScore;
	}

	/**
	 * 获取交通评分
	 * @return 交通评分
	 */
	public Float getTrafficScore() {
		return this.trafficScore;
	}

	/**
	 * 设置配套评分
	 * @param infrastructureScore 配套评分
	 */
	public void setInfrastructureScore(Float infrastructureScore) {
		this.infrastructureScore = infrastructureScore;
	}

	/**
	 * 获取配套评分
	 * @return 配套评分
	 */
	public Float getInfrastructureScore() {
		return this.infrastructureScore;
	}

	/**
	 * 设置环境评分
	 * @param enviromentScore 环境评分
	 */
	public void setEnviromentScore(Float enviromentScore) {
		this.enviromentScore = enviromentScore;
	}

	/**
	 * 获取环境评分
	 * @return 环境评分
	 */
	public Float getEnviromentScore() {
		return this.enviromentScore;
	}

	/**
	 * 设置总点评数
	 * @param totolCommetAmount 总点评数
	 */
	public void setTotolCommetAmount(Integer totolCommetAmount) {
		this.totolCommetAmount = totolCommetAmount;
	}

	/**
	 * 获取总点评数
	 * @return 总点评数
	 */
	public Integer getTotolCommetAmount() {
	    if(totolCommetAmount==null){
	        totolCommetAmount=0;
	    }
		return this.totolCommetAmount;
	}

	/**
	 * 设置综合评分
	 * @param integrationScore 综合评分
	 */
	public void setIntegrationScore(Float integrationScore) {
		this.integrationScore = integrationScore;
	}

	/**
	 * 获取综合评分
	 * @return 综合评分
	 */
	public Float getIntegrationScore() {
		return this.integrationScore;
	}

	/**
	 * 设置最早评论时间
	 * @param earliestComment 最早评论时间
	 */
	public void setEarliestComment(java.util.Date earliestComment) {
		this.earliestComment = earliestComment;
	}

	/**
	 * 设置最早评论时间字符串格式
	 * @param earliestComment 最早评论时间
	 */
	public void setEarliestCommentStr(String earliestComment) {
		if (!com.house365.web.util.StringUtils.isBlank(earliestComment)) {
			try {
				this.earliestComment = java.text.DateFormat.getDateTimeInstance().parse(earliestComment);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取最早评论时间
	 * @return 最早评论时间
	 */
	public java.util.Date getEarliestComment() {
		return this.earliestComment;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置是否删除 0:未删除 1:已删除
	 * @param isDeleted 是否删除 0:未删除 1:已删除
	 */
	public void setIsDeleted(Integer isDeleted) {
		this.isDeleted = isDeleted;
	}

	/**
	 * 获取是否删除 0:未删除 1:已删除
	 * @return 是否删除 0:未删除 1:已删除
	 */
	public Integer getIsDeleted() {
		return this.isDeleted;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("HouseId",getHouseId())
			.append("HouseName",getHouseName())
			.append("HousePhone",getHousePhone())
			.append("PriceScore",getPriceScore())
			.append("PlaceScore",getPlaceScore())
			.append("TrafficScore",getTrafficScore())
			.append("InfrastructureScore",getInfrastructureScore())
			.append("EnviromentScore",getEnviromentScore())
			.append("TotolCommetAmount",getTotolCommetAmount())
			.append("IntegrationScore",getIntegrationScore())
			.append("EarliestComment",getEarliestComment())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("IsDeleted",getIsDeleted())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmHouseEntity == false) return false;
		if(this == obj) return true;
		CmHouseEntity other = (CmHouseEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
	
	/**
	 * 获取综合得分
	 * 功能描述: <br>
	 * 〈功能详细描述〉
	 *
	 * @author yinchangming
	 * @version [v1.0.0, 2015年11月16日]
	 * @return
	 * @since [产品/模块版本](可选)
	 */
	public float countIntegratedScore(){
	    float total = this.getEnviromentScore()+this.getInfrastructureScore()+this.getPriceScore()+this.getTrafficScore()+this.getPlaceScore();
	    return total/5;
	}
	
	
}

